/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.packet.instrument.s2c;

import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.event.InstrumentOpenStateChangedEvent;
import com.cstav.genshinstrument.networking.IModPacket;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class NotifyInstrumentOpenPacket
implements IModPacket {
    public static final NetworkDirection NETWORK_DIRECTION = NetworkDirection.PLAY_TO_CLIENT;
    private final UUID playerUUID;
    private final boolean isOpen;
    private final Optional<BlockPos> pos;
    private final Optional<InteractionHand> hand;

    public NotifyInstrumentOpenPacket(UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.isOpen = false;
        this.pos = Optional.empty();
        this.hand = Optional.empty();
    }

    public NotifyInstrumentOpenPacket(UUID playerUUID, BlockPos pos) {
        this.playerUUID = playerUUID;
        this.isOpen = true;
        this.pos = Optional.of(pos);
        this.hand = Optional.empty();
    }

    public NotifyInstrumentOpenPacket(UUID playerUUID, InteractionHand hand) {
        this.playerUUID = playerUUID;
        this.isOpen = true;
        this.pos = Optional.empty();
        this.hand = Optional.of(hand);
    }

    public NotifyInstrumentOpenPacket(FriendlyByteBuf buf) {
        this.playerUUID = buf.m_130259_();
        this.isOpen = buf.readBoolean();
        this.pos = buf.m_236860_(FriendlyByteBuf::m_130135_);
        this.hand = buf.m_236860_(fbb -> (InteractionHand)fbb.m_130066_(InteractionHand.class));
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerUUID);
        buf.writeBoolean(this.isOpen);
        buf.m_236835_(this.pos, FriendlyByteBuf::m_130064_);
        buf.m_236835_(this.hand, FriendlyByteBuf::m_130068_);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        Player player = Minecraft.m_91087_().f_91073_.m_46003_(this.playerUUID);
        if (this.isOpen) {
            if (this.pos.isPresent()) {
                InstrumentOpenProvider.setOpen(player, this.pos.get());
            } else {
                InstrumentOpenProvider.setOpen(player, this.hand.get());
            }
        } else {
            InstrumentOpenProvider.setClosed(player);
        }
        MinecraftForge.EVENT_BUS.post((Event)new InstrumentOpenStateChangedEvent(this.isOpen, player, this.pos, this.hand));
    }
}

