/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.capability;

import com.cstav.genshinstrument.capability.instrumentOpen.InstrumentOpenProvider;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.NotifyInstrumentOpenPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="genshinstrument")
public class ModCapabilities {
    @SubscribeEvent
    public static void registerCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            if (!player.getCapability(InstrumentOpenProvider.INSTRUMENT_OPEN).isPresent()) {
                event.addCapability(new ResourceLocation("genshinstrument", "instrument_caps"), (ICapabilityProvider)new InstrumentOpenProvider());
            }
            InstrumentOpenProvider.setClosed(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ModCapabilities.notifyOpenStateToPlayers((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onDimensionChangedEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        ModCapabilities.notifyOpenStateToPlayers((ServerPlayer)event.getEntity());
    }

    private static void notifyOpenStateToPlayers(ServerPlayer target) {
        Level level = target.m_9236_();
        level.m_6907_().forEach(player -> {
            if (player.equals((Object)target)) {
                return;
            }
            if (InstrumentOpenProvider.isOpen(player)) {
                ModCapabilities.notifyOpenStateToPlayer(player, target);
            }
        });
    }

    private static void notifyOpenStateToPlayer(Player player, ServerPlayer target) {
        NotifyInstrumentOpenPacket packet = InstrumentOpenProvider.isItem(player) ? new NotifyInstrumentOpenPacket(player.m_20148_(), InstrumentOpenProvider.getHand(player)) : new NotifyInstrumentOpenPacket(player.m_20148_(), InstrumentOpenProvider.getBlockPos(player));
        GIPacketHandler.sendToClient(packet, target);
    }
}

