/*
 * Decompiled with CFR 0.152.
 */
package net.punisintendeds.fragmentskin.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.punisintendeds.fragmentskin.utils.helper.AlphaOverride;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public class Renderer2D {
    public static void setupRender() {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void endRender() {
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    public static float transformColor(float f) {
        return AlphaOverride.compute((int)(f * 255.0f)) / 255.0f;
    }

    public static class R2D {
        public static Vec2 renderTooltip(PoseStack stack, Color color, double arrowX, double arrowY, double width, double height, boolean renderUpsideDown) {
            double centerX = (double)Minecraft.m_91087_().m_91268_().m_85441_() / 2.0;
            boolean placeLeft = centerX < arrowX;
            double arrowDimX = 10.0;
            double arrowDimY = 5.0;
            double roundStartX = placeLeft ? arrowX + arrowDimX / 2.0 + 10.0 - width : arrowX - arrowDimX / 2.0 - 10.0;
            double roundStartY = renderUpsideDown ? arrowY - arrowDimY - height : arrowY + arrowDimY;
            Matrix4f mat = stack.m_85850_().m_252922_();
            Renderer2D.setupRender();
            RenderSystem.setShader(GameRenderer::m_172811_);
            float alpha = Renderer2D.transformColor((float)color.getAlpha() / 255.0f);
            R2D.renderRoundedQuadInternal(mat, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha, roundStartX, roundStartY, roundStartX + width, roundStartY + height, 5.0, 5.0, 5.0, 5.0, 20.0);
            Tesselator t = Tesselator.m_85913_();
            BufferBuilder bb = t.m_85915_();
            bb.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
            if (renderUpsideDown) {
                bb.m_252986_(mat, (float)arrowX, (float)arrowY - 0.5f, 0.0f).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha).m_5752_();
                bb.m_252986_(mat, (float)(arrowX - arrowDimX / 2.0), (float)(arrowY - arrowDimY - 0.5), 0.0f).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha).m_5752_();
                bb.m_252986_(mat, (float)(arrowX + arrowDimX / 2.0), (float)(arrowY - arrowDimY - 0.5), 0.0f).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha).m_5752_();
            } else {
                bb.m_252986_(mat, (float)arrowX, (float)arrowY + 0.5f, 0.0f).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha).m_5752_();
                bb.m_252986_(mat, (float)(arrowX - arrowDimX / 2.0), (float)(arrowY + arrowDimY + 0.5), 0.0f).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha).m_5752_();
                bb.m_252986_(mat, (float)(arrowX + arrowDimX / 2.0), (float)(arrowY + arrowDimY + 0.5), 0.0f).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha).m_5752_();
            }
            t.m_85914_();
            Renderer2D.endRender();
            return new Vec2((float)roundStartX, (float)roundStartY);
        }

        public static float[] getCheckmarkDimensions(float firstPart, float secondPart, float angle) {
            double a = Math.toRadians(angle - 90.0f);
            double b = Math.toRadians(angle);
            double firstPointY = Math.sin(a) * (double)firstPart;
            double firstPointX = Math.cos(a) * (double)firstPart;
            double secondPointY = Math.sin(b) * (double)secondPart;
            double secondPointX = Math.cos(b) * (double)secondPart;
            double minX = Math.min(0.0, Math.min(firstPointX, secondPointX));
            double maxX = Math.max(0.0, Math.max(firstPointX, secondPointX));
            double minY = Math.min(0.0, Math.min(firstPointY, secondPointY));
            double maxY = Math.max(0.0, Math.max(firstPointY, secondPointY));
            double width = maxX - minX;
            double height = maxY - minY;
            return new float[]{(float)minX, (float)minY, (float)maxX, (float)maxY, (float)width, (float)height};
        }

        public static void renderCheckmark(PoseStack matrices, Color color, double x, double y, float firstPart, float secondPart, float width, float angle) {
            matrices.m_85836_();
            matrices.m_85837_(x, y, 0.0);
            matrices.m_252781_(Axis.f_252403_.m_252977_(angle));
            matrices.m_252880_(-secondPart / 2.0f, firstPart / 2.0f, 0.0f);
            Matrix4f matrix = matrices.m_85850_().m_252922_();
            float a = Renderer2D.transformColor((float)color.getAlpha() / 255.0f);
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            Renderer2D.setupRender();
            RenderSystem.setShader(GameRenderer::m_172811_);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_252986_(matrix, 0.0f, -firstPart, 0.0f).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_252986_(matrix, width, 0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_252986_(matrix, width, -firstPart, 0.0f).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_252986_(matrix, secondPart, 0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_252986_(matrix, secondPart, -width, 0.0f).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_252986_(matrix, 0.0f, -width, 0.0f).m_85950_(r, g, b, a).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            Renderer2D.endRender();
            matrices.m_85849_();
        }

        public static void beginScissor(double x, double y, double endX, double endY) {
            double width = endX - x;
            double height = endY - y;
            width = Math.max(0.0, width);
            height = Math.max(0.0, height);
            float mulScale = (float)Minecraft.m_91087_().m_91268_().m_85449_();
            int invertedY = (int)(((double)Minecraft.m_91087_().m_91268_().m_85442_() - (y + height)) * (double)mulScale);
            RenderSystem.enableScissor((int)((int)(x * (double)mulScale)), (int)invertedY, (int)((int)(width * (double)mulScale)), (int)((int)(height * (double)mulScale)));
        }

        public static void endScissor() {
            RenderSystem.disableScissor();
        }

        public static void renderTexture(PoseStack matrices, double x0, double y0, double width, double height, float u, float v, double regionWidth, double regionHeight, double textureWidth, double textureHeight) {
            double x1 = x0 + width;
            double y1 = y0 + height;
            double z = 0.0;
            R2D.renderTexturedQuad(matrices.m_85850_().m_252922_(), x0, x1, y0, y1, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight);
        }

        public static void renderRoundedShadowInternal(Matrix4f matrix, float cr, float cg, float cb, float ca, double fromX, double fromY, double toX, double toY, double rad, double samples, double wid) {
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            double toX1 = toX - rad;
            double toY1 = toY - rad;
            double fromX1 = fromX + rad;
            double fromY1 = fromY + rad;
            double[][] map = new double[][]{{toX1, toY1}, {toX1, fromY1}, {fromX1, fromY1}, {fromX1, toY1}};
            for (int i = 0; i < map.length; ++i) {
                double[] current = map[i];
                for (double r = (double)i * 90.0; r < 90.0 + (double)i * 90.0; r += 90.0 / samples) {
                    float rad1 = (float)Math.toRadians(r);
                    float sin = (float)(Math.sin(rad1) * rad);
                    float cos = (float)(Math.cos(rad1) * rad);
                    bufferBuilder.m_252986_(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
                    float sin1 = (float)((double)sin + Math.sin(rad1) * wid);
                    float cos1 = (float)((double)cos + Math.cos(rad1) * wid);
                    bufferBuilder.m_252986_(matrix, (float)current[0] + sin1, (float)current[1] + cos1, 0.0f).m_85950_(cr, cg, cb, 0.0f).m_5752_();
                }
            }
            double[] current = map[0];
            float rad1 = (float)Math.toRadians(0.0);
            float sin = (float)(Math.sin(rad1) * rad);
            float cos = (float)(Math.cos(rad1) * rad);
            bufferBuilder.m_252986_(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
            float sin1 = (float)((double)sin + Math.sin(rad1) * wid);
            float cos1 = (float)((double)cos + Math.cos(rad1) * wid);
            bufferBuilder.m_252986_(matrix, (float)current[0] + sin1, (float)current[1] + cos1, 0.0f).m_85950_(cr, cg, cb, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }

        public static void renderRoundedShadow(PoseStack matrices, Color innerColor, double fromX, double fromY, double toX, double toY, double rad, double samples, double shadowWidth) {
            int color = innerColor.getRGB();
            Matrix4f matrix = matrices.m_85850_().m_252922_();
            float f = (float)(color >> 24 & 0xFF) / 255.0f;
            float g = (float)(color >> 16 & 0xFF) / 255.0f;
            float h = (float)(color >> 8 & 0xFF) / 255.0f;
            float k = (float)(color & 0xFF) / 255.0f;
            Renderer2D.setupRender();
            RenderSystem.setShader(GameRenderer::m_172811_);
            R2D.renderRoundedShadowInternal(matrix, g, h, k, Renderer2D.transformColor(f), fromX, fromY, toX, toY, rad, samples, shadowWidth);
            Renderer2D.endRender();
        }

        public static void renderLoadingSpinner(PoseStack stack, float alpha, double x, double y, double rad, double width, double segments) {
            float v = Renderer2D.transformColor(alpha);
            stack.m_85836_();
            stack.m_85837_(x, y, 0.0);
            float rot = (float)(System.currentTimeMillis() % 2000L) / 2000.0f;
            stack.m_252781_(Axis.f_252403_.m_252977_(rot * 360.0f));
            double segments1 = Mth.m_14008_((double)segments, (double)2.0, (double)90.0);
            Matrix4f matrix = stack.m_85850_().m_252922_();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            Renderer2D.setupRender();
            RenderSystem.setShader(GameRenderer::m_172811_);
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            for (double r = 0.0; r < 90.0; r += 90.0 / segments1) {
                double rad1 = Math.toRadians(r);
                double sin = Math.sin(rad1);
                double cos = Math.cos(rad1);
                double offX = sin * rad;
                double offY = cos * rad;
                float prog = (float)r / 360.0f;
                prog -= rot;
                Color hsb = Color.getHSBColor(prog %= 1.0f, 0.6f, 1.0f);
                float g = (float)hsb.getRed() / 255.0f;
                float h = (float)hsb.getGreen() / 255.0f;
                float k = (float)hsb.getBlue() / 255.0f;
                bufferBuilder.m_252986_(matrix, (float)offX, (float)offY, 0.0f).m_85950_(g, h, k, v).m_5752_();
                bufferBuilder.m_252986_(matrix, (float)(offX + sin * width), (float)(offY + cos * width), 0.0f).m_85950_(g, h, k, v).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            stack.m_85849_();
            Renderer2D.endRender();
        }

        private static void renderTexturedQuad(Matrix4f matrix, double x0, double x1, double y0, double y1, double z, float u0, float u1, float v0, float v1) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_252986_(matrix, (float)x0, (float)y1, (float)z).m_7421_(u0, v1).m_5752_();
            bufferBuilder.m_252986_(matrix, (float)x1, (float)y1, (float)z).m_7421_(u1, v1).m_5752_();
            bufferBuilder.m_252986_(matrix, (float)x1, (float)y0, (float)z).m_7421_(u1, v0).m_5752_();
            bufferBuilder.m_252986_(matrix, (float)x0, (float)y0, (float)z).m_7421_(u0, v0).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }

        public static void runWithinBlendMask(Runnable maskDrawer, Runnable regularDrawer) {
            RenderSystem.enableBlend();
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.clear((int)16384, (boolean)false);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.setShader(GameRenderer::m_172811_);
            maskDrawer.run();
            RenderSystem.blendFunc((int)772, (int)773);
            regularDrawer.run();
            RenderSystem.defaultBlendFunc();
        }

        public static void renderCircle(PoseStack matrices, Color c, double originX, double originY, double rad, int segments) {
            int segments1 = Mth.m_14045_((int)segments, (int)4, (int)360);
            int color = c.getRGB();
            Matrix4f matrix = matrices.m_85850_().m_252922_();
            float f = Renderer2D.transformColor((float)(color >> 24 & 0xFF) / 255.0f);
            float g = (float)(color >> 16 & 0xFF) / 255.0f;
            float h = (float)(color >> 8 & 0xFF) / 255.0f;
            float k = (float)(color & 0xFF) / 255.0f;
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            Renderer2D.setupRender();
            RenderSystem.setShader(GameRenderer::m_172811_);
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            for (int i = 0; i < 360; i += Math.min(360 / segments1, 360 - i)) {
                double radians = Math.toRadians(i);
                double sin = Math.sin(radians) * rad;
                double cos = Math.cos(radians) * rad;
                bufferBuilder.m_252986_(matrix, (float)(originX + sin), (float)(originY + cos), 0.0f).m_85950_(g, h, k, f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }

        public static boolean isOnScreen(Vec3 pos) {
            return pos != null && pos.f_82481_ > -1.0 && pos.f_82481_ < 1.0;
        }

        public static Vec3 getScreenSpaceCoordinate(Vec3 pos, PoseStack stack) {
            Camera camera = Minecraft.m_91087_().m_91290_().f_114358_;
            Matrix4f matrix = stack.m_85850_().m_252922_();
            int displayHeight = Minecraft.m_91087_().m_91268_().m_85442_();
            int[] viewport = new int[4];
            Vector3f target = new Vector3f();
            double deltaX = pos.f_82479_ - camera.m_90583_().f_82479_;
            double deltaY = pos.f_82480_ - camera.m_90583_().f_82480_;
            double deltaZ = pos.f_82481_ - camera.m_90583_().f_82481_;
            GL11.glGetIntegerv((int)2978, (int[])viewport);
            Vector4f transformedCoordinates = new Vector4f((float)deltaX, (float)deltaY, (float)deltaZ, 1.0f).mul((Matrix4fc)matrix);
            Matrix4f matrixProj = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
            Matrix4f matrixModel = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
            matrixProj.mul((Matrix4fc)matrixModel).project(transformedCoordinates.x(), transformedCoordinates.y(), transformedCoordinates.z(), viewport, target);
            return new Vec3((double)target.x / Minecraft.m_91087_().m_91268_().m_85449_(), (double)((float)displayHeight - target.y) / Minecraft.m_91087_().m_91268_().m_85449_(), (double)target.z);
        }

        public static Vec3 screenSpaceToWorldOffset(double x, double y, double z) {
            double yCopy = y;
            double xCopy = x;
            Matrix4f projMat = RenderSystem.getProjectionMatrix();
            xCopy /= (double)Minecraft.m_91087_().m_91268_().m_85441_();
            yCopy /= (double)Minecraft.m_91087_().m_91268_().m_85442_();
            xCopy = xCopy * 2.0 - 1.0;
            yCopy = yCopy * 2.0 - 1.0;
            Vector4f pos = new Vector4f((float)xCopy, (float)yCopy, (float)z, 1.0f);
            pos.mul((Matrix4fc)projMat);
            if (pos.w() == 0.0f) {
                return null;
            }
            pos.normalize();
            return new Vec3((double)pos.x(), (double)pos.y(), (double)pos.z());
        }

        public static void renderQuad(PoseStack matrices, Color c, double x1, double y1, double x2, double y2) {
            double j;
            double x11 = x1;
            double x21 = x2;
            double y11 = y1;
            double y21 = y2;
            int color = c.getRGB();
            if (x11 < x21) {
                j = x11;
                x11 = x21;
                x21 = j;
            }
            if (y11 < y21) {
                j = y11;
                y11 = y21;
                y21 = j;
            }
            Matrix4f matrix = matrices.m_85850_().m_252922_();
            float f = Renderer2D.transformColor((float)(color >> 24 & 0xFF) / 255.0f);
            float g = (float)(color >> 16 & 0xFF) / 255.0f;
            float h = (float)(color >> 8 & 0xFF) / 255.0f;
            float k = (float)(color & 0xFF) / 255.0f;
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            Renderer2D.setupRender();
            RenderSystem.setShader(GameRenderer::m_172811_);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_252986_(matrix, (float)x11, (float)y21, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_252986_(matrix, (float)x21, (float)y21, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_252986_(matrix, (float)x21, (float)y11, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_252986_(matrix, (float)x11, (float)y11, 0.0f).m_85950_(g, h, k, f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            Renderer2D.endRender();
        }

        public static void renderQuadGradient(PoseStack matrices, Color c2, Color c1, double x1, double y1, double x2, double y2, boolean vertical) {
            double j;
            double x11 = x1;
            double x21 = x2;
            double y11 = y1;
            double y21 = y2;
            float r1 = (float)c1.getRed() / 255.0f;
            float g1 = (float)c1.getGreen() / 255.0f;
            float b1 = (float)c1.getBlue() / 255.0f;
            float a1 = Renderer2D.transformColor((float)c1.getAlpha() / 255.0f);
            float r2 = (float)c2.getRed() / 255.0f;
            float g2 = (float)c2.getGreen() / 255.0f;
            float b2 = (float)c2.getBlue() / 255.0f;
            float a2 = Renderer2D.transformColor((float)c2.getAlpha() / 255.0f);
            if (x11 < x21) {
                j = x11;
                x11 = x21;
                x21 = j;
            }
            if (y11 < y21) {
                j = y11;
                y11 = y21;
                y21 = j;
            }
            Matrix4f matrix = matrices.m_85850_().m_252922_();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            Renderer2D.setupRender();
            RenderSystem.setShader(GameRenderer::m_172811_);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            if (vertical) {
                bufferBuilder.m_252986_(matrix, (float)x11, (float)y11, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
                bufferBuilder.m_252986_(matrix, (float)x11, (float)y21, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
                bufferBuilder.m_252986_(matrix, (float)x21, (float)y21, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
                bufferBuilder.m_252986_(matrix, (float)x21, (float)y11, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
            } else {
                bufferBuilder.m_252986_(matrix, (float)x11, (float)y11, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
                bufferBuilder.m_252986_(matrix, (float)x11, (float)y21, 0.0f).m_85950_(r1, g1, b1, a1).m_5752_();
                bufferBuilder.m_252986_(matrix, (float)x21, (float)y21, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
                bufferBuilder.m_252986_(matrix, (float)x21, (float)y11, 0.0f).m_85950_(r2, g2, b2, a2).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            Renderer2D.endRender();
        }

        public static void renderRoundedQuadInternal(Matrix4f matrix, float cr, float cg, float cb, float ca, double fromX, double fromY, double toX, double toY, double rad, double samples) {
            R2D.renderRoundedQuadInternal(matrix, cr, cg, cb, ca, fromX, fromY, toX, toY, rad, rad, rad, rad, samples);
        }

        public static void renderRoundedQuadInternal(Matrix4f matrix, float cr, float cg, float cb, float ca, double fromX, double fromY, double toX, double toY, double radC1, double radC2, double radC3, double radC4, double samples) {
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            double[][] map = new double[][]{{toX - radC4, toY - radC4, radC4}, {toX - radC2, fromY + radC2, radC2}, {fromX + radC1, fromY + radC1, radC1}, {fromX + radC3, toY - radC3, radC3}};
            for (int i = 0; i < 4; ++i) {
                double[] current = map[i];
                double rad = current[2];
                for (double r = (double)i * 90.0; r < 90.0 + (double)i * 90.0; r += 90.0 / samples) {
                    float rad1 = (float)Math.toRadians(r);
                    float sin = (float)(Math.sin(rad1) * rad);
                    float cos = (float)(Math.cos(rad1) * rad);
                    bufferBuilder.m_252986_(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
                }
                float rad1 = (float)Math.toRadians(90.0 + (double)i * 90.0);
                float sin = (float)(Math.sin(rad1) * rad);
                float cos = (float)(Math.cos(rad1) * rad);
                bufferBuilder.m_252986_(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }

        public static void renderRoundedQuadWithShadow(PoseStack matrices, Color c, double fromX, double fromY, double toX, double toY, double rad, double samples) {
            int color = c.getRGB();
            Matrix4f matrix = matrices.m_85850_().m_252922_();
            float f = Renderer2D.transformColor((float)(color >> 24 & 0xFF) / 255.0f);
            float g = (float)(color >> 16 & 0xFF) / 255.0f;
            float h = (float)(color >> 8 & 0xFF) / 255.0f;
            float k = (float)(color & 0xFF) / 255.0f;
            Renderer2D.setupRender();
            RenderSystem.setShader(GameRenderer::m_172811_);
            R2D.renderRoundedQuadInternal(matrix, g, h, k, f, fromX, fromY, toX, toY, rad, rad, rad, rad, samples);
            R2D.renderRoundedShadow(matrices, new Color(10, 10, 10, 100), fromX, fromY, toX, toY, rad, samples, 3.0);
            Renderer2D.endRender();
        }

        public static void renderRoundedQuad(PoseStack matrices, Color c, double fromX, double fromY, double toX, double toY, double radC1, double radC2, double radC3, double radC4, double samples) {
            int color = c.getRGB();
            Matrix4f matrix = matrices.m_85850_().m_252922_();
            float f = Renderer2D.transformColor((float)(color >> 24 & 0xFF) / 255.0f);
            float g = (float)(color >> 16 & 0xFF) / 255.0f;
            float h = (float)(color >> 8 & 0xFF) / 255.0f;
            float k = (float)(color & 0xFF) / 255.0f;
            Renderer2D.setupRender();
            RenderSystem.setShader(GameRenderer::m_172811_);
            R2D.renderRoundedQuadInternal(matrix, g, h, k, f, fromX, fromY, toX, toY, radC1, radC2, radC3, radC4, samples);
            Renderer2D.endRender();
        }

        public static void renderRoundedQuad(PoseStack stack, Color c, double x, double y, double x1, double y1, double rad, double samples) {
            R2D.renderRoundedQuad(stack, c, x, y, x1, y1, rad, rad, rad, rad, samples);
        }

        public static void renderRoundedOutlineInternal(Matrix4f matrix, float cr, float cg, float cb, float ca, double fromX, double fromY, double toX, double toY, double radC1, double radC2, double radC3, double radC4, double width, double samples) {
            double rad;
            double[] current;
            int i;
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            double[][] map = new double[][]{{toX - radC4, toY - radC4, radC4}, {toX - radC2, fromY + radC2, radC2}, {fromX + radC1, fromY + radC1, radC1}, {fromX + radC3, toY - radC3, radC3}};
            for (i = 0; i < 4; ++i) {
                current = map[i];
                rad = current[2];
                for (double r = (double)i * 90.0; r < 90.0 + (double)i * 90.0; r += 90.0 / samples) {
                    float rad1 = (float)Math.toRadians(r);
                    double sin1 = Math.sin(rad1);
                    float sin = (float)(sin1 * rad);
                    double cos1 = Math.cos(rad1);
                    float cos = (float)(cos1 * rad);
                    bufferBuilder.m_252986_(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
                    bufferBuilder.m_252986_(matrix, (float)(current[0] + (double)sin + sin1 * width), (float)(current[1] + (double)cos + cos1 * width), 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
                }
                float rad1 = (float)Math.toRadians(90.0 + (double)i * 90.0);
                double sin1 = Math.sin(rad1);
                float sin = (float)(sin1 * rad);
                double cos1 = Math.cos(rad1);
                float cos = (float)(cos1 * rad);
                bufferBuilder.m_252986_(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
                bufferBuilder.m_252986_(matrix, (float)(current[0] + (double)sin + sin1 * width), (float)(current[1] + (double)cos + cos1 * width), 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
            }
            i = 0;
            current = map[i];
            rad = current[2];
            float cos = (float)rad;
            bufferBuilder.m_252986_(matrix, (float)current[0], (float)current[1] + cos, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
            bufferBuilder.m_252986_(matrix, (float)current[0], (float)(current[1] + (double)cos + width), 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }

        public static void renderRoundedOutline(PoseStack matrices, Color c, double fromX, double fromY, double toX, double toY, double rad1, double rad2, double rad3, double rad4, double width, double samples) {
            int color = c.getRGB();
            Matrix4f matrix = matrices.m_85850_().m_252922_();
            float f = (float)(color >> 24 & 0xFF) / 255.0f;
            float g = (float)(color >> 16 & 0xFF) / 255.0f;
            float h = (float)(color >> 8 & 0xFF) / 255.0f;
            float k = (float)(color & 0xFF) / 255.0f;
            Renderer2D.setupRender();
            RenderSystem.setShader(GameRenderer::m_172811_);
            R2D.renderRoundedOutlineInternal(matrix, g, h, k, f, fromX, fromY, toX, toY, rad1, rad2, rad3, rad4, width, samples);
            Renderer2D.endRender();
        }

        public static void renderLine(PoseStack stack, Color c, double x, double y, double x1, double y1) {
            float g = (float)c.getRed() / 255.0f;
            float h = (float)c.getGreen() / 255.0f;
            float k = (float)c.getBlue() / 255.0f;
            float f = Renderer2D.transformColor((float)c.getAlpha() / 255.0f);
            Matrix4f m = stack.m_85850_().m_252922_();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            Renderer2D.setupRender();
            RenderSystem.setShader(GameRenderer::m_172811_);
            bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_252986_(m, (float)x, (float)y, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_252986_(m, (float)x1, (float)y1, 0.0f).m_85950_(g, h, k, f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            Renderer2D.endRender();
        }

        public static void renderRoundedTextureQuad(PoseStack stack, String texture, double x, double y, double x1, double y1, double rad, double samples) {
            R2D.renderRoundedTextureQuad(stack, ResourceLocation.m_135820_((String)texture), x, y, x1, y1, rad, rad, rad, rad, samples);
        }

        public static void renderRoundedTextureQuad(PoseStack stack, ResourceLocation texture, double x, double y, double x1, double y1, double rad, double samples) {
            R2D.renderRoundedTextureQuad(stack, texture, x, y, x1, y1, rad, rad, rad, rad, samples);
        }

        public static void renderRoundedTextureQuad(PoseStack matrices, ResourceLocation texture, double fromX, double fromY, double toX, double toY, double radC1, double radC2, double radC3, double radC4, double samples) {
            Matrix4f matrix = matrices.m_85850_().m_252922_();
            Renderer2D.setupRender();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            RenderSystem.setShader(GameRenderer::m_172817_);
            R2D.renderRoundedTextureQuadInternal(matrix, fromX, fromY, toX, toY, radC1, radC2, radC3, radC4, samples);
            Renderer2D.endRender();
        }

        public static void renderRoundedTextureQuadInternal(Matrix4f matrix, double fromX, double fromY, double toX, double toY, double radC1, double radC2, double radC3, double radC4, double samples) {
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
            double centerX = (fromX + toX) / 2.0;
            double centerY = (fromY + toY) / 2.0;
            bufferBuilder.m_252986_(matrix, (float)centerX, (float)centerY, 0.0f).m_7421_(0.5f, 0.5f).m_5752_();
            double[][] corners = new double[][]{{toX - radC4, toY - radC4, radC4}, {toX - radC2, fromY + radC2, radC2}, {fromX + radC1, fromY + radC1, radC1}, {fromX + radC3, toY - radC3, radC3}};
            for (int i = 0; i < 4; ++i) {
                double[] current = corners[i];
                double cx = current[0];
                double cy = current[1];
                double radius = current[2];
                int j = 0;
                while ((double)j <= samples) {
                    double angle = Math.toRadians((double)i * 90.0 + (double)j * (90.0 / samples));
                    float x = (float)(cx + Math.sin(angle) * radius);
                    float y = (float)(cy + Math.cos(angle) * radius);
                    float u = (float)(((double)x - fromX) / (toX - fromX));
                    float v = (float)(((double)y - fromY) / (toY - fromY));
                    bufferBuilder.m_252986_(matrix, x, y, 0.0f).m_7421_(u, v).m_5752_();
                    ++j;
                }
            }
            double[] first = corners[0];
            double firstAngle = Math.toRadians(0.0);
            float x = (float)(first[0] + Math.sin(firstAngle) * first[2]);
            float y = (float)(first[1] + Math.cos(firstAngle) * first[2]);
            float u = (float)(((double)x - fromX) / (toX - fromX));
            float v = (float)(((double)y - fromY) / (toY - fromY));
            bufferBuilder.m_252986_(matrix, x, y, 0.0f).m_7421_(u, v).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
    }
}

