/*
 * Decompiled with CFR 0.152.
 */
package net.punisintendeds.fragmentskin.screen.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import java.awt.Color;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.punisintendeds.fragmentlibs.client.utils.HudRenderer;
import net.punisintendeds.fragmentskin.network.DataUtils;
import net.punisintendeds.fragmentskin.screen.SkinChangingScreen;
import net.punisintendeds.fragmentskin.screen.helper.CheckButton;

public class SkinListWidget
extends ObjectSelectionList<SkinEntry> {
    private final Int2DoubleOpenHashMap hoveringHeights = new Int2DoubleOpenHashMap();
    private final float MAX_HOVER_HEIGHT;
    private static final float HOVER_SPEED = 3.0f;

    public SkinListWidget(Minecraft minecraftClient, int i, int j, int k, int l, int m) {
        super(minecraftClient, i, j, k, l, m);
        this.m_93488_(false);
        this.m_93496_(false);
        this.MAX_HOVER_HEIGHT = m * 3;
    }

    protected void m_239227_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int i = this.m_5747_();
        int j = this.m_5759_();
        int k = this.f_93387_ - 4;
        int l = this.m_5773_();
        double cumulativeOffset = 0.0;
        for (int m = 0; m < l; ++m) {
            int n = this.m_7610_(m);
            int o = this.m_93485_(m);
            double currentHoverHeight = this.hoveringHeights.getOrDefault(m, 0.0);
            double adjustedY = (double)n + cumulativeOffset;
            SkinEntry entry = (SkinEntry)this.m_93500_(m);
            boolean isHovered = mouseX >= i && mouseX <= i + j && (double)mouseY >= adjustedY && (double)mouseY <= adjustedY + (double)k + currentHoverHeight;
            currentHoverHeight = isHovered ? (double)((int)Mth.m_14139_((double)0.2, (double)currentHoverHeight, (double)this.MAX_HOVER_HEIGHT)) : (double)((int)Mth.m_14139_((double)0.2, (double)currentHoverHeight, (double)0.0));
            if (currentHoverHeight > 0.0) {
                this.hoveringHeights.put(m, currentHoverHeight);
            } else {
                this.hoveringHeights.remove(m);
            }
            entry.render_animation(context, m, (int)adjustedY, i, j, (int)((double)k + currentHoverHeight), mouseX, mouseY, isHovered, k);
            cumulativeOffset += currentHoverHeight;
        }
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int k = this.m_5747_();
        int l = this.f_93391_ + 4 - (int)this.m_93517_();
        this.m_280310_(context);
        this.m_7415_(context, k, l);
        this.m_239227_(context, mouseX, mouseY, delta);
        context.m_280618_();
        RenderSystem.disableBlend();
    }

    protected int m_5756_() {
        return this.f_93388_ + 4;
    }

    public int m_5759_() {
        return this.f_93388_ - 20;
    }

    public int m_93520_() {
        return this.m_5747_() + this.m_5759_();
    }

    protected void m_280310_(GuiGraphics context) {
        context.m_280588_(this.f_93393_, this.f_93390_, this.f_93392_ * 3, this.f_93391_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int i = this.m_5747_();
        int j = this.m_5759_();
        int k = this.f_93387_ - 4;
        int l = this.m_5773_();
        double cumulativeOffset = 0.0;
        for (int m = 0; m < l; ++m) {
            int n = this.m_7610_(m);
            int o = this.m_93485_(m);
            double currentHoverHeight = this.hoveringHeights.getOrDefault(m, 0.0);
            double adjustedY = (double)n + cumulativeOffset;
            if ((double)o + cumulativeOffset >= (double)this.f_93390_ && adjustedY <= (double)this.f_93391_) {
                boolean isClicked;
                SkinEntry entry = (SkinEntry)this.m_93500_(m);
                boolean bl = isClicked = mouseX >= (double)i && mouseX <= (double)(i + j) && mouseY >= adjustedY && mouseY <= adjustedY + (double)k + currentHoverHeight;
                if (isClicked) {
                    for (SkinEntry child : this.m_6702_()) {
                        child.clear();
                    }
                    entry.m_6375_(mouseX, mouseY, button);
                    return true;
                }
            }
            cumulativeOffset += currentHoverHeight;
        }
        return false;
    }

    public static class SkinEntry
    extends ObjectSelectionList.Entry<SkinEntry> {
        private final String name;
        private final PressAction action;
        public boolean isSelected = false;
        private Map<String, Object> data;
        private boolean clicked = false;
        private Font textRenderer;

        public SkinEntry(String name, PressAction action) {
            this.textRenderer = Minecraft.m_91087_().f_91062_;
            this.name = name;
            this.action = action;
            this.data = DataUtils.getJson(name);
        }

        public String getName() {
            return this.name;
        }

        public void m_6311_(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        }

        public void render_animation(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, int originalEntryHeight) {
            ResourceLocation texture;
            Color color = isHovered ? new Color(112, 249, 62) : new Color(170, 217, 251);
            if (this.isSelected) {
                color = new Color(160, 62, 251);
            }
            int skinX = x + 6;
            int skinY = y + 2;
            int skinSize = originalEntryHeight - 6;
            int i = 8;
            int j = 8;
            ResourceLocation resourceLocation = texture = this.m_5953_(mouseX, mouseY) ? SkinChangingScreen.setSkin(this.name, true) : SkinChangingScreen.setSkin(this.name, false);
            if (((Boolean)this.data.getOrDefault("noSpoil", false)).booleanValue()) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            context.m_280411_(texture, skinX + 1, skinY + 1, skinSize - 2, skinSize - 2, 8.0f, (float)i, 8, j, 64, 64);
            RenderSystem.enableBlend();
            context.m_280411_(texture, skinX, skinY, skinSize, skinSize, 40.0f, (float)i, 8, j, 64, 64);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            HudRenderer.renderFrame((GuiGraphics)context, (float)(x + 1), (float)y, (float)(x + entryWidth - 2), (float)(y + entryHeight - 2), (Color)color, (Color)new Color(0, 0, 0, 150), (float)1.0f);
            context.m_280588_(x + 3, y + 2, x + entryWidth - 4, y + entryHeight - 4);
            int textX = skinX + originalEntryHeight;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            int textY = y + (originalEntryHeight - 9) / 2;
            context.m_280056_(Minecraft.m_91087_().f_91062_, this.getName(), textX, textY, -1, false);
            boolean updated = false;
            float boxSize = (float)originalEntryHeight / 2.0f;
            float centerX = (float)(x + entryWidth) - boxSize;
            float centerY = (float)(y + originalEntryHeight) + boxSize / 2.0f;
            int n = x + (int)boxSize / 2;
            Objects.requireNonNull(this.textRenderer);
            context.m_280056_(this.textRenderer, "Slim Arm", n, (int)(centerY - 9.0f / 2.0f), 0xFFFFFF, true);
            updated |= CheckButton.renderWidget(context, centerX - boxSize / 2.0f, centerY - boxSize / 2.0f, centerX + boxSize / 2.0f, centerY + boxSize / 2.0f, mouseX, mouseY, this.clicked, (Boolean)this.data.getOrDefault("notSlim", false) == false, () -> this.data.put("notSlim", (Boolean)this.data.getOrDefault("notSlim", false) == false));
            Objects.requireNonNull(this.textRenderer);
            int n2 = x + (int)boxSize / 2;
            Objects.requireNonNull(this.textRenderer);
            context.m_280056_(this.textRenderer, "Use Mouth", n2, (int)((centerY += 9.0f + boxSize / 2.0f) - 9.0f / 2.0f), 0xFFFFFF, true);
            updated |= CheckButton.renderWidget(context, centerX - boxSize / 2.0f, centerY - boxSize / 2.0f, centerX + boxSize / 2.0f, centerY + boxSize / 2.0f, mouseX, mouseY, this.clicked, (Boolean)this.data.getOrDefault("isMouth", false), () -> this.data.put("isMouth", (Boolean)this.data.getOrDefault("isMouth", false) == false));
            Objects.requireNonNull(this.textRenderer);
            int n3 = x + (int)boxSize / 2;
            Objects.requireNonNull(this.textRenderer);
            context.m_280056_(this.textRenderer, "No Spoil", n3, (int)((centerY += 9.0f + boxSize / 2.0f) - 9.0f / 2.0f), 0xFFFFFF, true);
            if (updated |= CheckButton.renderWidget(context, centerX - boxSize / 2.0f, centerY - boxSize / 2.0f, centerX + boxSize / 2.0f, centerY + boxSize / 2.0f, mouseX, mouseY, this.clicked, (Boolean)this.data.getOrDefault("noSpoil", false), () -> this.data.put("noSpoil", (Boolean)this.data.getOrDefault("noSpoil", false) == false))) {
                DataUtils.writeJson(this.data, this.name);
                this.action.onPress(this.getName());
            }
            context.m_280618_();
            this.clicked = false;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.clicked = true;
            this.isSelected = true;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            this.action.onPress(this.getName());
            return super.m_6375_(mouseX, mouseY, button);
        }

        public void clear() {
            this.isSelected = false;
        }

        public Component m_142172_() {
            return Component.m_237119_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface PressAction {
        public void onPress(String var1);
    }
}

