/*
 * Decompiled with CFR 0.152.
 */
package net.punisintendeds.fragmentskin.screen.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.punisintendeds.fragmentskin.screen.helper.RoundedButton;
import org.jetbrains.annotations.Nullable;

public class ImageButton
extends RoundedButton {
    private final ResourceLocation image;

    public ImageButton(int x, int y, int width, int height, Component message, RoundedButton.PressAction onPress, ResourceLocation image) {
        super(x, y, width, height, message, onPress);
        this.image = image;
    }

    @Override
    protected void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_87963_(context, mouseX, mouseY, delta);
        Color color = this.m_5953_(mouseX, mouseY) ? new Color(0, 0, 0) : new Color(35, 84, 254);
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        context.m_280163_(this.image, this.m_252754_() + 2, this.m_252907_() + 2, 0.0f, 0.0f, this.f_93618_ - 4, this.f_93619_ - 4, this.f_93618_ - 4, this.f_93619_ - 4);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static ImageButtonBuilder builder(Component message, RoundedButton.PressAction onPress, ResourceLocation identifier) {
        return new ImageButtonBuilder(message, onPress, identifier);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ImageButtonBuilder {
        private final Component message;
        private final RoundedButton.PressAction onPress;
        private final ResourceLocation identifier;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;

        public ImageButtonBuilder(Component message, RoundedButton.PressAction onPress, ResourceLocation identifier) {
            this.message = message;
            this.onPress = onPress;
            this.identifier = identifier;
        }

        public ImageButtonBuilder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public ImageButtonBuilder width(int width) {
            this.width = width;
            return this;
        }

        public ImageButtonBuilder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public ImageButtonBuilder dimensions(int x, int y, int width, int height) {
            return this.position(x, y).size(width, height);
        }

        public ImageButtonBuilder tooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public ImageButton build() {
            ImageButton buttonWidget = new ImageButton(this.x, this.y, this.width, this.height, this.message, this.onPress, this.identifier);
            buttonWidget.m_257544_(this.tooltip);
            return buttonWidget;
        }
    }
}

