/*
 * Decompiled with CFR 0.152.
 */
package net.punisintendeds.fragmentskin.screen;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.punisintendeds.fragmentlibs.client.obj.ObjModel;
import net.punisintendeds.fragmentlibs.client.obj.ObjRenderer;
import net.punisintendeds.fragmentlibs.client.utils.HudRenderer;
import net.punisintendeds.fragmentskin.FragmentSkin;
import net.punisintendeds.fragmentskin.init.Models;
import net.punisintendeds.fragmentskin.network.DataUtils;
import net.punisintendeds.fragmentskin.network.SkinUtils;
import net.punisintendeds.fragmentskin.network.UploadUtils;
import net.punisintendeds.fragmentskin.screen.helper.ImageButton;
import net.punisintendeds.fragmentskin.screen.helper.RoundedButton;
import net.punisintendeds.fragmentskin.screen.helper.SkinListWidget;
import net.punisintendeds.fragmentskin.screen.helper.TextBoxButton;
import net.punisintendeds.fragmentskin.utils.helper.Easing;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class SkinChangingScreen
extends Screen {
    private float scrollOffset;
    private double openProgress = 0.0;
    private double guiProgress = 0.0;
    private static final int TEXTURE_SIZE = 64;
    private boolean isCreatingScreen = false;
    private double creatingScreenProgress = 0.0;
    private long lastModified = 0L;
    private static boolean updateSkin = false;
    private static PlayerModel<AbstractClientPlayer> playerModel;
    private float playerRotation = 0.0f;
    private float playerPitch = 0.0f;
    private ResourceLocation skinTexture;
    Map<String, Object> data;
    List<Renderable> settingChilds = Lists.newArrayList();
    private SkinListWidget skinList;
    float time = -32145.236f;
    private File closeSkin;
    private File openSkin;
    private int dragWidth;
    private int dragHeight;
    private int closeX;
    private int closeY;
    private int openX;
    private int openY;
    private TextBoxButton nameBox;
    private TextBoxButton displayNameBox;
    private int originalGuiScale = -1;
    private boolean pendingResize = false;

    public SkinChangingScreen() {
        this(true, 0.0f);
    }

    public SkinChangingScreen(boolean isAnim, float scrollOffset) {
        super((Component)Component.m_237113_((String)"skin_changing"));
        this.skinTexture = new ResourceLocation("textures/entity/player/slim/steve.png");
        SkinUtils.getSkin(Minecraft.m_91087_().m_91094_().m_240411_(), "close", identifier -> {
            if (identifier != null) {
                this.skinTexture = identifier;
            }
        });
        this.scrollOffset = scrollOffset;
        playerModel = new PlayerModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171166_), false);
        this.playerRotation = 200.0f;
        if (!isAnim) {
            this.openProgress = 1.0;
        }
    }

    public void m_7861_() {
        super.m_7861_();
        if ((Integer)this.f_96541_.f_91066_.m_231928_().m_231551_() != this.originalGuiScale) {
            this.f_96541_.f_91066_.m_231928_().m_231514_((Object)this.originalGuiScale);
            this.f_96541_.m_5741_();
        }
    }

    public void m_7379_() {
        super.m_7379_();
        if ((Integer)this.f_96541_.f_91066_.m_231928_().m_231551_() != this.originalGuiScale) {
            this.f_96541_.f_91066_.m_231928_().m_231514_((Object)this.originalGuiScale);
            this.f_96541_.m_5741_();
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.pendingResize) {
            this.pendingResize = false;
            this.f_96541_.f_91066_.m_231928_().m_231514_((Object)4);
            this.f_96541_.m_5741_();
        }
    }

    protected void m_7856_() {
        if (this.originalGuiScale == -1) {
            this.originalGuiScale = (Integer)this.f_96541_.f_91066_.m_231928_().m_231551_();
        }
        if ((Integer)this.f_96541_.f_91066_.m_231928_().m_231551_() != 4) {
            this.pendingResize = true;
        }
        super.m_7856_();
        this.m_6702_().clear();
        this.skinList = new SkinListWidget(this.f_96541_, (int)((float)this.f_96543_ * 0.25f - (float)this.f_96543_ * 0.02f), (int)((float)this.f_96544_ * 0.9166667f - (float)this.f_96544_ * 0.083333336f), (int)((float)this.f_96544_ * 0.25f), (int)((float)this.f_96544_ * 0.9166667f), this.f_96544_ / 9);
        this.skinList.m_93507_((int)((double)this.f_96543_ * 0.011000000000000001));
        this.m_7787_((GuiEventListener)this.skinList);
        File runDir = Minecraft.m_91087_().f_91069_;
        File skins = new File(runDir, "fragmentskin/skins");
        this.skinList.m_6702_().clear();
        if (skins.exists() && skins.listFiles() != null) {
            for (File skin : skins.listFiles()) {
                this.skinList.m_6702_().add(new SkinListWidget.SkinEntry(skin.getName(), id -> {
                    this.skinTexture = SkinChangingScreen.setSkin(id, false);
                    this.data = DataUtils.getJson(id);
                    playerModel = DataUtils.getBooleanValue(this.data, "notSlim", false) ? new PlayerModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171162_), false) : new PlayerModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171166_), false);
                }));
            }
        }
        for (SkinListWidget.SkinEntry child : this.skinList.m_6702_()) {
            Map<String, Object> data = DataUtils.getJson(child.getName());
            if (!child.isSelected) continue;
            if (DataUtils.getBooleanValue(data, "notSlim", false)) {
                playerModel = new PlayerModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171162_), false);
                continue;
            }
            playerModel = new PlayerModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171166_), false);
        }
        this.m_142416_((GuiEventListener)ImageButton.builder((Component)Component.m_237113_((String)""), button -> this.startCreateSkin(), FragmentSkin.id("textures/gui/new.png")).position((int)((float)this.f_96543_ * 0.06666667f), (int)((float)this.f_96544_ * 0.11111111f)).size(this.f_96543_ / 20, this.f_96543_ / 20).build());
        this.m_142416_((GuiEventListener)ImageButton.builder((Component)Component.m_237113_((String)""), button -> {
            File skin = new File(this.f_96541_.f_91069_, "fragmentskin/skins");
            if (skin.exists()) {
                try {
                    Util.m_137581_().m_137644_(skin);
                }
                catch (Exception e) {
                    System.out.println("Desktop is not supported on this platform.");
                }
            }
        }, FragmentSkin.id("textures/gui/folder.png")).position((int)((float)this.f_96543_ * 0.13333334f), (int)((float)this.f_96544_ * 0.11111111f)).size(this.f_96543_ / 20, this.f_96543_ / 20).build());
        this.m_142416_((GuiEventListener)ImageButton.builder((Component)Component.m_237113_((String)""), button -> {
            for (SkinListWidget.SkinEntry child : this.skinList.m_6702_()) {
                UUID uuid = Minecraft.m_91087_().m_91094_().m_240411_();
                if (!child.isSelected || uuid == null) continue;
                UploadUtils.UploadSkin(child.getName(), uuid);
                DataUtils.save(DataUtils.getJson(child.getName()), uuid);
            }
        }, FragmentSkin.id("textures/gui/upload.png")).position((int)((float)this.f_96543_ * 0.5f) - this.f_96543_ / 40, (int)((float)this.f_96544_ * 0.8888889f)).size(this.f_96543_ / 20, this.f_96543_ / 20).build());
        this.settingChilds.clear();
        this.settingChilds.add((Renderable)RoundedButton.builder((Component)Component.m_237113_((String)"Cancel"), button -> this.stopCreateSkin()).position((int)((double)this.f_96543_ * 0.36333333333333334), (int)((float)this.f_96544_ * 0.76666665f)).size(this.f_96543_ / 8, this.f_96543_ / 37).build());
        this.settingChilds.add((Renderable)RoundedButton.builder((Component)Component.m_237113_((String)"Create"), button -> {
            if (this.nameBox.m_94155_().isEmpty()) {
                this.stopCreateSkin();
                return;
            }
            File skinCreated = new File(this.f_96541_.f_91069_, "fragmentskin/skins/" + this.nameBox.m_94155_());
            if (!skinCreated.exists()) {
                skinCreated.mkdirs();
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("notSlim", false);
            if (!this.displayNameBox.m_94155_().isEmpty()) {
                data.put("displayName", this.displayNameBox.m_94155_());
            }
            if (this.closeSkin != null && this.closeSkin.exists()) {
                try {
                    Files.copy(this.closeSkin.toPath(), skinCreated.toPath().resolve("close.png"), StandardCopyOption.REPLACE_EXISTING);
                    if (this.openSkin == null || !this.openSkin.exists()) {
                        data.put("isMouth", false);
                    } else {
                        Files.copy(this.openSkin.toPath(), skinCreated.toPath().resolve("open.png"), StandardCopyOption.REPLACE_EXISTING);
                        data.put("isMouth", true);
                    }
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    FileWriter writer = new FileWriter(skinCreated.toPath().resolve("data.json").toFile(), StandardCharsets.UTF_8);
                    gson.toJson(data, (Appendable)writer);
                    writer.close();
                }
                catch (Exception o) {
                    o.printStackTrace();
                }
            }
            this.stopCreateSkin();
        }).position((int)((double)this.f_96543_ * 0.5133333333333333), (int)((float)this.f_96544_ * 0.76666665f)).size(this.f_96543_ / 8, this.f_96543_ / 37).build());
        this.dragWidth = (int)((float)this.f_96543_ / 4.9f);
        this.dragHeight = this.f_96544_ / 15;
        this.openX = this.closeX = (int)((float)this.f_96543_ / 2.0f - (float)this.dragWidth / 3.6f);
        this.closeY = (int)((double)this.f_96544_ * 0.355) - this.dragHeight / 3;
        this.openY = (int)((double)this.f_96544_ * 0.47000000000000003) - this.dragHeight / 3;
        int displayY = (int)((double)this.f_96544_ * 0.58);
        int nameBoxY = (int)((double)this.f_96544_ * 0.23500000000000001);
        this.displayNameBox = new TextBoxButton(this.f_96541_.f_91062_, this.closeX, displayY, this.dragWidth, this.dragHeight, (Component)Component.m_237113_((String)"Component.."));
        this.nameBox = new TextBoxButton(this.f_96541_.f_91062_, this.closeX, nameBoxY, this.dragWidth, this.dragHeight, (Component)Component.m_237113_((String)"Component.."));
        this.settingChilds.add((Renderable)this.displayNameBox);
        this.settingChilds.add((Renderable)this.nameBox);
    }

    private void startCreateSkin() {
        this.isCreatingScreen = true;
    }

    private void stopCreateSkin() {
        this.isCreatingScreen = false;
        this.openSkin = null;
        this.closeSkin = null;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.nameBox.m_7933_(keyCode, scanCode, modifiers);
        this.displayNameBox.m_7933_(keyCode, scanCode, modifiers);
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        this.nameBox.m_5534_(chr, modifiers);
        this.displayNameBox.m_5534_(chr, modifiers);
        return super.m_5534_(chr, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.skinList.m_5953_(mouseX, mouseY)) {
            this.skinList.m_6050_(mouseX, mouseY, amount);
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isCreatingScreen) {
            for (Renderable settingChild : this.settingChilds) {
                AbstractWidget clickableWidget;
                if (settingChild instanceof AbstractWidget && (clickableWidget = (AbstractWidget)settingChild).m_5953_(mouseX, mouseY)) {
                    clickableWidget.m_6375_(mouseX, mouseY, button);
                }
                if (!(settingChild instanceof TextBoxButton)) continue;
                TextBoxButton textFieldWidget = (TextBoxButton)settingChild;
                textFieldWidget.m_93692_(textFieldWidget.m_5953_(mouseX, mouseY));
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        float skinPreviewWidth = (int)Mth.m_14139_((double)this.creatingScreenProgress, (double)((float)this.f_96543_ * 0.27272728f), (double)((float)this.f_96543_ * 0.75f));
        if (button == 0 && mouseX > (double)skinPreviewWidth && mouseY > (double)((float)this.f_96544_ * 0.083333336f) && mouseX < (double)((float)this.f_96543_ * 0.99f) && mouseY < (double)((float)this.f_96544_ * 0.9166667f)) {
            this.playerRotation -= (float)deltaX;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            this.m_280273_(context);
        }
        PoseStack matrices = context.m_280168_();
        this.openProgress = Math.min(1.0, this.openProgress + (double)(delta / 10.0f));
        float size = Easing.EXPO_OUT.ease(Math.min(1.0, this.openProgress), 0.0, 1.0, 1.0);
        this.creatingScreenProgress = this.isCreatingScreen ? Mth.m_14008_((double)Mth.m_14139_((double)(delta / 5.0f), (double)this.creatingScreenProgress, (double)1.0), (double)0.0, (double)1.0) : Mth.m_14008_((double)Mth.m_14139_((double)(delta / 5.0f), (double)this.creatingScreenProgress, (double)0.0), (double)0.0, (double)1.0);
        matrices.m_85836_();
        matrices.m_252880_((1.0f - size) * (float)this.f_96543_ / 2.0f, (1.0f - size) * (float)this.f_96544_ / 2.0f, 0.0f);
        matrices.m_85841_(size, size, size);
        context.m_280509_(0, 0, this.f_96543_, this.f_96544_, new Color(20, 20, 29).getRGB());
        this.scrollOffset = (this.scrollOffset + delta * 1.15f) % 64.0f;
        this.renderTile(context, new Color(22, 22, 31).getRGB());
        this.renderModelBackground(context, matrices);
        if (!(this.openProgress > 0.8)) {
            return;
        }
        this.guiProgress = Mth.m_14139_((double)0.07, (double)this.guiProgress, (double)1.0);
        HudRenderer.renderFrame((GuiGraphics)context, (float)((float)this.f_96543_ * 0.01f), (float)((float)this.f_96544_ * 0.083333336f), (float)((float)this.f_96543_ * 0.25f), (float)((int)Mth.m_14139_((double)this.guiProgress, (double)((float)this.f_96544_ * 0.083333336f), (double)((float)this.f_96544_ * 0.9166667f))), (Color)new Color(96, 131, 252), (Color)new Color(0, 0, 0, 150), (float)1.0f);
        int skinPreviewWidth = (int)Mth.m_14139_((double)this.creatingScreenProgress, (double)((float)this.f_96543_ * 0.27272728f), (double)((float)this.f_96543_ * 0.75f));
        int skinTop = (int)Mth.m_14139_((double)this.creatingScreenProgress, (double)((float)this.f_96544_ * 0.1f), (double)((float)this.f_96544_ * 0.083333336f));
        int skinBottom = (int)Mth.m_14139_((double)this.creatingScreenProgress, (double)((float)this.f_96544_ * 0.875f), (double)((float)this.f_96544_ * 0.9166667f));
        HudRenderer.renderFrame((GuiGraphics)context, (float)skinPreviewWidth, (float)skinTop, (float)((float)this.f_96543_ * 0.99f), (float)((int)Mth.m_14139_((double)this.guiProgress, (double)((float)this.f_96544_ * 0.083333336f), (double)skinBottom)), (Color)new Color(96, 131, 252), (Color)new Color(0, 0, 0, 150), (float)1.0f);
        matrices.m_252880_(0.0f, 0.0f, 1000.0f);
        float settingWidth = (float)Mth.m_14139_((double)this.creatingScreenProgress, (double)((float)this.f_96543_ * 0.27272728f), (double)((float)this.f_96543_ * 0.71999997f));
        if (this.creatingScreenProgress > (double)0.01f) {
            HudRenderer.renderFrame((GuiGraphics)context, (float)((float)this.f_96543_ * 0.27272728f), (float)((float)this.f_96544_ * 0.1f), (float)settingWidth, (float)((float)this.f_96544_ * 0.875f), (Color)new Color(96, 131, 252), (Color)new Color(0, 0, 0, 150), (float)1.0f);
            context.m_280588_((int)((float)this.f_96543_ * 0.27272728f), (int)((float)this.f_96544_ * 0.1f), (int)settingWidth, (int)((float)this.f_96544_ * 0.875f));
            this.renderSetting(context, mouseX, mouseY, delta);
            for (Renderable settingChild : this.settingChilds) {
                settingChild.m_88315_(context, mouseX, mouseY, delta);
            }
            context.m_280618_();
        }
        context.m_280588_(skinPreviewWidth, (int)((float)this.f_96544_ * 0.083333336f), (int)((float)this.f_96543_ * 0.99f), (int)Mth.m_14139_((double)this.guiProgress, (double)((float)this.f_96544_ * 0.083333336f), (double)((float)this.f_96544_ * 0.9166667f)));
        float previewSize = (float)this.f_96543_ * 0.99f - (float)skinPreviewWidth;
        this.renderPlayerModel(context, (int)((float)skinPreviewWidth + previewSize / 2.0f), this.f_96544_ / 35, 1, this.playerRotation, this.playerPitch);
        context.m_280618_();
        context.m_280588_((int)((float)this.f_96543_ * 0.01f), (int)((float)this.f_96544_ * 0.083333336f), (int)((float)this.f_96543_ * 0.25f), (int)Mth.m_14139_((double)this.guiProgress, (double)((float)this.f_96544_ * 0.083333336f), (double)((float)this.f_96544_ * 0.9166667f)));
        this.skinList.m_88315_(context, mouseX, mouseY, delta);
        context.m_280618_();
        super.m_88315_(context, mouseX, mouseY, delta);
        this.isFolderUpdated();
        matrices.m_85849_();
    }

    private String convertDisplayPath(File path) {
        String fullPath = path.getAbsolutePath();
        int maxWidth = this.dragWidth - 2;
        Object displayPath = fullPath;
        int textWidth = this.f_96541_.f_91062_.m_92895_((String)displayPath);
        if (textWidth > maxWidth) {
            String trimmedPath = fullPath;
            String prefix = "...";
            while (this.f_96541_.f_91062_.m_92895_(prefix + trimmedPath) > maxWidth && trimmedPath.length() > 1) {
                trimmedPath = trimmedPath.substring(1);
            }
            displayPath = prefix + trimmedPath;
        }
        return displayPath;
    }

    private void renderSetting(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int textY;
        int textX;
        String displayPath;
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        matrices.m_252880_(0.0f, 0.0f, 1000.0f);
        if (this.f_96541_ == null) {
            return;
        }
        context.m_280056_(this.f_96541_.f_91062_, "Create Skin", this.f_96543_ / 2 - this.f_96541_.f_91062_.m_92895_("Create Skin") / 2, (int)((double)this.f_96544_ * 0.125), -1, false);
        context.m_280056_(this.f_96541_.f_91062_, "File Name", (int)((double)this.f_96543_ * 0.29090909090909095), (int)((float)this.f_96544_ * 0.25f), -1, false);
        context.m_280056_(this.f_96541_.f_91062_, "Close Mouth", (int)((double)this.f_96543_ * 0.29090909090909095), (int)((double)this.f_96544_ * 0.355), -1, false);
        context.m_280056_(this.f_96541_.f_91062_, "Open Mouth", (int)((double)this.f_96543_ * 0.29090909090909095), (int)((double)this.f_96544_ * 0.47000000000000003), -1, false);
        context.m_280056_(this.f_96541_.f_91062_, "Display Name", (int)((double)this.f_96543_ * 0.29090909090909095), (int)((double)this.f_96544_ * 0.605), -1, false);
        HudRenderer.renderFrame((GuiGraphics)context, (float)this.closeX, (float)this.closeY, (float)(this.closeX + this.dragWidth), (float)(this.closeY + this.dragHeight), (Color)new Color(96, 131, 252), (Color)new Color(0, 0, 0, 150), (float)1.0f);
        HudRenderer.renderFrame((GuiGraphics)context, (float)this.openX, (float)this.openY, (float)(this.openX + this.dragWidth), (float)(this.openY + this.dragHeight), (Color)new Color(96, 131, 252), (Color)new Color(0, 0, 0, 150), (float)1.0f);
        if (this.closeSkin != null) {
            displayPath = this.convertDisplayPath(this.closeSkin);
            textX = this.closeX + this.dragWidth / 2 - this.f_96541_.f_91062_.m_92895_(displayPath) / 2;
            Objects.requireNonNull(this.f_96541_.f_91062_);
            textY = this.closeY + 9;
            context.m_280056_(this.f_96541_.f_91062_, displayPath, textX, textY, -1, false);
        }
        if (this.openSkin != null) {
            displayPath = this.convertDisplayPath(this.openSkin);
            textX = this.openX + this.dragWidth / 2 - this.f_96541_.f_91062_.m_92895_(displayPath) / 2;
            Objects.requireNonNull(this.f_96541_.f_91062_);
            textY = this.openY + 9;
            context.m_280056_(this.f_96541_.f_91062_, displayPath, textX, textY, -1, false);
        }
        matrices.m_85849_();
    }

    public void renderTile(GuiGraphics context, int stripeColor) {
        float stripeWidth = 30.0f;
        float spacing = 60.0f;
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        matrices.m_252880_((float)this.f_96543_, (float)this.f_96544_, 0.0f);
        matrices.m_252781_(Axis.f_252403_.m_252977_(45.0f));
        matrices.m_252880_((float)(-this.f_96543_), (float)(-this.f_96544_), 0.0f);
        matrices.m_85841_(1.0f, 10.0f, 1.0f);
        MultiBufferSource.BufferSource immediate = context.m_280091_();
        RenderType layer = RenderType.m_285907_();
        VertexConsumer buffer = immediate.m_6299_(layer);
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        int numStripes = (int)((float)(this.f_96543_ + this.f_96544_) / spacing) + 4;
        for (int i = -2; i < numStripes; ++i) {
            float x = (float)i * spacing + this.scrollOffset;
            buffer.m_252986_(matrix, x, 0.0f, 0.0f).m_193479_(stripeColor);
            buffer.m_252986_(matrix, x, (float)this.f_96544_, 0.0f).m_193479_(stripeColor);
            buffer.m_252986_(matrix, x + stripeWidth, (float)this.f_96544_, 0.0f).m_193479_(stripeColor);
            buffer.m_252986_(matrix, x + stripeWidth, 0.0f, 0.0f).m_193479_(stripeColor);
        }
        immediate.m_109911_();
        matrices.m_85849_();
    }

    private void renderModelBackground(GuiGraphics context, PoseStack matrices) {
        matrices.m_85836_();
        matrices.m_85837_((double)this.f_96543_ / 2.0, (double)this.f_96544_ / 2.0, 400.0);
        float scale = -0.1f * ((float)this.f_96544_ / 2.0f);
        matrices.m_85841_(scale, scale, scale);
        this.time += Minecraft.m_91087_().m_91296_();
        matrices.m_85836_();
        matrices.m_252781_(Axis.f_252436_.m_252977_(this.time));
        matrices.m_252781_(Axis.f_252529_.m_252961_((float)Math.sin(Math.toRadians(this.time))));
        matrices.m_252781_(Axis.f_252403_.m_252961_((float)Math.cos(Math.toRadians(this.time))));
        MultiBufferSource.BufferSource immediate = context.m_280091_();
        RenderType layer = RenderType.m_110470_((ResourceLocation)FragmentSkin.id("textures/gui/base.png"));
        matrices.m_85841_(3.0f, 3.0f, 3.0f);
        ObjRenderer.render((ObjModel)Models.SPIRAL, (PoseStack)matrices, (MultiBufferSource)immediate, (RenderType)layer, (int)0xF000F0, (Color)new Color(156, 75, 255));
        matrices.m_85841_(1.04f, 1.04f, 1.04f);
        ObjRenderer.render((ObjModel)Models.SPIRAL_FLIP, (PoseStack)matrices, (MultiBufferSource)immediate, (RenderType)RenderType.m_110497_((ResourceLocation)FragmentSkin.id("textures/gui/base.png")), (int)0xF000F0, (Color)new Color(226, 176, 255));
        matrices.m_85849_();
        this.renderHalo(matrices, immediate, new Vec3(10.0, 10.0, 10.0), 9.0f, 0.0f, new Vec3(24.0, 0.0, -24.0));
        this.renderSciFi(matrices, immediate, new Vec3(6.0, 6.0, 6.0), 1.0f, 0.7f, new Vec3(0.0, 0.0, 0.0));
        this.renderSciFi(matrices, immediate, new Vec3(3.0, 3.0, 3.0), 2.0f, 1.0f, new Vec3(0.0, 0.0, 0.0));
        immediate.m_109911_();
        matrices.m_85849_();
    }

    private void renderSciFi(PoseStack matrices, MultiBufferSource.BufferSource immediate, Vec3 scale, float offset, float rotationSpeed, Vec3 initRotation) {
        matrices.m_85836_();
        RenderType layer = RenderType.m_110470_((ResourceLocation)FragmentSkin.id("textures/gui/base.png"));
        float t = this.time;
        float distanceTime = t * rotationSpeed;
        float seed = this.hash(offset * 97.123f);
        matrices.m_252781_(Axis.f_252436_.m_252977_(distanceTime + seed));
        matrices.m_252781_(Axis.f_252529_.m_252977_(distanceTime + seed));
        matrices.m_252781_(Axis.f_252403_.m_252977_(distanceTime + seed));
        matrices.m_252781_(Axis.f_252436_.m_252977_((float)initRotation.f_82479_));
        matrices.m_252781_(Axis.f_252529_.m_252977_((float)initRotation.f_82480_));
        matrices.m_252781_(Axis.f_252403_.m_252977_((float)initRotation.f_82481_));
        matrices.m_85841_((float)scale.f_82479_, (float)scale.f_82480_, (float)scale.f_82481_);
        ObjRenderer.render((ObjModel)Models.SCIFI_SPHERE, (PoseStack)matrices, (MultiBufferSource)immediate, (RenderType)layer, (int)0xF000F0, (Color)new Color(95, 79, 241));
        matrices.m_85841_(1.02f, 1.02f, 1.02f);
        ObjRenderer.render((ObjModel)Models.SCIFI_SPHERE_FLIP, (PoseStack)matrices, (MultiBufferSource)immediate, (RenderType)RenderType.m_110497_((ResourceLocation)FragmentSkin.id("textures/gui/base.png")), (int)0xF000F0, (Color)new Color(171, 103, 255));
        matrices.m_85849_();
    }

    private void renderHalo(PoseStack matrices, MultiBufferSource.BufferSource immediate, Vec3 scale, float offset, float rotationSpeed, Vec3 initRotation) {
        matrices.m_85836_();
        RenderType layer = RenderType.m_110470_((ResourceLocation)FragmentSkin.id("textures/gui/base.png"));
        float t = this.time;
        float distanceTime = t * rotationSpeed;
        float seed = this.hash(offset * 97.123f);
        matrices.m_252781_(Axis.f_252436_.m_252977_(distanceTime + seed));
        matrices.m_252781_(Axis.f_252529_.m_252977_(distanceTime + seed));
        matrices.m_252781_(Axis.f_252403_.m_252977_(distanceTime + seed));
        matrices.m_252781_(Axis.f_252436_.m_252977_((float)initRotation.f_82479_));
        matrices.m_252781_(Axis.f_252529_.m_252977_((float)initRotation.f_82480_));
        matrices.m_252781_(Axis.f_252403_.m_252977_((float)initRotation.f_82481_));
        matrices.m_85841_((float)scale.f_82479_, (float)scale.f_82480_, (float)scale.f_82481_);
        matrices.m_85837_(Math.sin(t / 21.123f) / 10.0, Math.cos(t / 47.7123f) / 10.0, 0.0);
        ObjRenderer.render((ObjModel)Models.HALO, (PoseStack)matrices, (MultiBufferSource)immediate, (RenderType)layer, (int)0xF000F0, (Color)new Color(95, 79, 241));
        matrices.m_85841_(-1.02f, -1.02f, -1.02f);
        ObjRenderer.render((ObjModel)Models.HALO, (PoseStack)matrices, (MultiBufferSource)immediate, (RenderType)RenderType.m_110497_((ResourceLocation)FragmentSkin.id("textures/gui/base.png")), (int)0xF000F0, (Color)new Color(171, 103, 255));
        matrices.m_85849_();
    }

    private float hash(float x) {
        return (float)(Math.sin(x * 12.9898f + 78.233f) % 1.0);
    }

    private void renderPlayerModel(GuiGraphics context, int x, int y, int scale, float rotationYaw, float rotationPitch) {
        PoseStack matrices = context.m_280168_();
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        matrices.m_85836_();
        matrices.m_252880_((float)x, (float)y, 1000.0f);
        matrices.m_85841_((float)(-(scale *= (int)((float)this.f_96544_ / 2.0f))), (float)scale, (float)scale);
        matrices.m_272245_(Axis.f_252529_.m_252977_(-20.0f), 0.0f, 1.0f, 0.0f);
        matrices.m_252781_(Axis.f_252436_.m_252977_(rotationYaw));
        SkinChangingScreen.playerModel.f_102817_ = false;
        playerModel.m_5585_().m_233569_();
        playerModel.m_5585_().m_253072_(new Vector3f(-0.3f, -0.3f, -0.3f));
        SkinChangingScreen.playerModel.f_102811_.m_233569_();
        SkinChangingScreen.playerModel.f_102812_.m_233569_();
        SkinChangingScreen.playerModel.f_102811_.m_252854_(new Vector3f(0.0f, -0.5f, 0.0f));
        SkinChangingScreen.playerModel.f_102812_.m_252854_(new Vector3f(0.0f, -0.5f, 0.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.skinTexture);
        Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        if (DataUtils.getBooleanValue(this.data, "noSpoil", false)) {
            color = new Color(0.0f, 0.0f, 0.0f, 1.0f);
        }
        VertexConsumer vertexConsumer = immediate.m_6299_(RenderType.m_110473_((ResourceLocation)this.skinTexture));
        playerModel.m_7695_(matrices, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
        immediate.m_109911_();
        matrices.m_85849_();
    }

    public boolean isFolderUpdated() {
        try {
            Path path = new File(Minecraft.m_91087_().f_91069_, "fragmentskin/skins/").toPath();
            long currentModified = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            if (currentModified > this.lastModified) {
                this.m_7856_();
                this.lastModified = currentModified;
                updateSkin = true;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ResourceLocation setSkin(String skin, boolean isOpen) {
        return SkinChangingScreen.setSkin(skin, isOpen, false);
    }

    public static ResourceLocation setSkin(String skin, boolean isOpen, boolean isUpdate) {
        File open;
        File file = new File(Minecraft.m_91087_().f_91069_, "fragmentskin/skins/" + skin + "/close.png");
        if (isOpen && (open = new File(Minecraft.m_91087_().f_91069_, "fragmentskin/skins/" + skin + "/open.png")).exists()) {
            file = open;
        }
        if (file.exists()) {
            ResourceLocation resourceLocation;
            String id = file.getAbsolutePath().toLowerCase(Locale.US).replace("\\", "/").replace(' ', '_').replaceAll("[^a-z0-9/._-]", "");
            if (Minecraft.m_91087_().m_91097_().m_174786_(FragmentSkin.id(id), null) != null && updateSkin) {
                updateSkin = false;
                return FragmentSkin.id(id);
            }
            FileInputStream inputStream = new FileInputStream(file);
            try {
                NativeImage image = NativeImage.m_85058_((InputStream)inputStream);
                inputStream.close();
                Minecraft.m_91087_().execute(() -> {
                    ResourceLocation TextureId = FragmentSkin.id(id);
                    TextureManager tm = Minecraft.m_91087_().m_91097_();
                    tm.m_118513_(TextureId);
                    DynamicTexture Texture = new DynamicTexture(image);
                    tm.m_118495_(TextureId, (AbstractTexture)Texture);
                });
                resourceLocation = FragmentSkin.id(id);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new ResourceLocation("textures/entity/player/slim/steve.png");
                }
            }
            inputStream.close();
            return resourceLocation;
        }
        return new ResourceLocation("textures/entity/player/slim/steve.png");
    }

    public void m_7400_(List<Path> paths) {
        int mouseX = (int)(this.f_96541_.f_91067_.m_91589_() * (double)this.f_96541_.m_91268_().m_85445_() / (double)this.f_96541_.m_91268_().m_85443_());
        int mouseY = (int)(this.f_96541_.f_91067_.m_91594_() * (double)this.f_96541_.m_91268_().m_85446_() / (double)this.f_96541_.m_91268_().m_85444_());
        if (paths.size() == 2) {
            this.closeSkin = paths.get(0).toFile();
            this.openSkin = paths.get(1).toFile();
            return;
        }
        if (this.closeX < mouseX && mouseX < this.closeX + this.dragWidth && this.closeY < mouseY && mouseY < this.closeY + this.dragHeight) {
            this.closeSkin = paths.get(0).toFile();
        } else if (this.openX < mouseX && mouseX < this.openX + this.dragWidth && this.openY < mouseY && mouseY < this.openY + this.dragHeight) {
            this.openSkin = paths.get(0).toFile();
        }
    }
}

