/*
 * Decompiled with CFR 0.152.
 */
package net.punisintendeds.fragmentskin.plugin;

import java.util.Optional;
import java.util.UUID;
import net.punisintendeds.fragmentskin.plugin.VoiceUtils;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.addon.AddonInitializer;
import su.plo.voice.api.addon.InjectPlasmoVoice;
import su.plo.voice.api.addon.annotation.Addon;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.source.ClientSelfSourceInfo;
import su.plo.voice.api.client.event.audio.source.AudioSourceWriteEvent;
import su.plo.voice.api.client.event.connection.UdpClientPacketReceivedEvent;
import su.plo.voice.api.event.EventPriority;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.data.player.VoicePlayerInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.udp.clientbound.SelfAudioInfoPacket;

@Addon(id="pv-addon-voice-check", name="Voice Check", version="1.0.0", authors={"PunIsIntendeds"})
public final class VoiceCheck
implements AddonInitializer {
    @InjectPlasmoVoice
    private static PlasmoVoiceClient voiceClient;

    public void onAddonInitialize() {
        voiceClient.getEventBus().register((Object)this, UdpClientPacketReceivedEvent.class, EventPriority.NORMAL, this::onSelfAudioPacket);
        voiceClient.getEventBus().register((Object)this, AudioSourceWriteEvent.class, EventPriority.NORMAL, this::onSourceWrite);
    }

    public void onSourceWrite(@NotNull AudioSourceWriteEvent event) {
        SourceInfo sourceInfo = event.getSource().getSourceInfo();
        if (!(sourceInfo instanceof PlayerSourceInfo)) {
            return;
        }
        PlayerSourceInfo playerSourceInfo = (PlayerSourceInfo)sourceInfo;
        VoicePlayerInfo playerInfo = playerSourceInfo.getPlayerInfo();
        UUID uuid = playerInfo.getPlayerId();
        VoiceUtils.setVoice(uuid);
    }

    public void onSelfAudioPacket(UdpClientPacketReceivedEvent event) {
        Packet packet = event.getPacket();
        if (!(packet instanceof SelfAudioInfoPacket)) {
            return;
        }
        SelfAudioInfoPacket infoPacket = (SelfAudioInfoPacket)packet;
        Optional selfSourceInfo = voiceClient.getSourceManager().getSelfSourceInfo(infoPacket.getSourceId());
        if (selfSourceInfo.isEmpty()) {
            return;
        }
        SourceInfo sourceInfo = ((ClientSelfSourceInfo)selfSourceInfo.get()).getSelfSourceInfo().getSourceInfo();
        if (!(sourceInfo instanceof PlayerSourceInfo)) {
            return;
        }
        PlayerSourceInfo playerSourceInfo = (PlayerSourceInfo)sourceInfo;
        VoicePlayerInfo playerInfo = playerSourceInfo.getPlayerInfo();
        UUID uuid = playerInfo.getPlayerId();
        VoiceUtils.setVoice(uuid);
    }
}

