/*
 * Decompiled with CFR 0.152.
 */
package net.punisintendeds.fragmentskin.network;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.punisintendeds.fragmentskin.FragmentSkin;

public class SkinUtils {
    public static void getSkin(UUID uuid, String type, Consumer<ResourceLocation> callback) {
        FragmentSkin.LOGGER.info("Getting Skin: {}", (Object)uuid);
        CompletableFuture.runAsync(() -> {
            try {
                String url = FragmentSkin.getUrl("skins") + uuid.toString() + "-" + type + ".png";
                InputStream inputStream = new URL(url).openStream();
                NativeImage nativeImage = NativeImage.m_85058_((InputStream)inputStream);
                inputStream.close();
                Minecraft.m_91087_().execute(() -> {
                    ResourceLocation skin = SkinUtils.registerDynamicTexture(String.valueOf(uuid) + "-" + type, nativeImage);
                    callback.accept(skin);
                });
            }
            catch (IOException e) {
                Minecraft.m_91087_().execute(() -> callback.accept(null));
            }
        });
    }

    private static ResourceLocation registerDynamicTexture(String name, NativeImage image) {
        if (image == null) {
            return null;
        }
        ResourceLocation textureId = FragmentSkin.id("skins-" + name);
        TextureManager tm = Minecraft.m_91087_().m_91097_();
        tm.m_118513_(textureId);
        DynamicTexture texture = new DynamicTexture(image);
        tm.m_118495_(textureId, (AbstractTexture)texture);
        return textureId;
    }
}

