/*
 * Decompiled with CFR 0.152.
 */
package net.punisintendeds.fragmentskin.network;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.punisintendeds.fragmentskin.FragmentSkin;

public class DataUtils {
    public static void save(Map<String, Object> map, UUID uuid) {
        CompletableFuture.runAsync(() -> {
            try {
                String json = new GsonBuilder().disableHtmlEscaping().create().toJson((Object)map);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(FragmentSkin.getUrl("savejson"))).header("Content-Type", "application/json; charset=UTF-8").header("Accept-Charset", "UTF-8").header("Filename", uuid.toString()).POST(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).build();
                HttpResponse<String> httpResponse = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void get(UUID uuid, Consumer<Map<String, Object>> callback) {
        CompletableFuture.runAsync(() -> {
            try {
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(FragmentSkin.getUrl("getjson") + uuid.toString())).GET().build();
                HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
                Type mapType = new TypeToken<Map<String, String>>(){}.getType();
                try {
                    Map map = (Map)new Gson().fromJson(response.body(), mapType);
                    Minecraft.m_91087_().execute(() -> callback.accept(map));
                }
                catch (JsonSyntaxException e) {
                    Minecraft.m_91087_().execute(() -> callback.accept(null));
                }
            }
            catch (Exception e) {
                Minecraft.m_91087_().execute(() -> callback.accept(null));
            }
        });
    }

    public static void writeJson(Map<String, Object> data, String name) {
        File file = new File(Minecraft.m_91087_().f_91069_, "fragmentskin/skins/" + name + "/data.json");
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);
            gson.toJson(data, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Object> getJson(String name) {
        HashMap<String, Object> hashMap;
        Gson gson = new Gson();
        Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
        File file = new File(Minecraft.m_91087_().f_91069_, "fragmentskin/skins/" + name + "/data.json");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("notSlim", false);
        map.put("isMouth", false);
        if (!file.exists()) {
            return map;
        }
        FileReader reader = new FileReader(file, StandardCharsets.UTF_8);
        try {
            Map loaded = (Map)gson.fromJson((Reader)reader, mapType);
            if (loaded != null) {
                map.putAll(loaded);
            }
            hashMap = map;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return map;
            }
        }
        reader.close();
        return hashMap;
    }

    public static boolean getBooleanValue(Map<String, Object> map, String key, boolean defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    public static String getStringValue(Map<String, Object> map, String key, String defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }
}

