/*
 * Decompiled with CFR 0.152.
 */
package net.punisintendeds.fragmentskin.mixin;

import com.google.common.base.MoreObjects;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.punisintendeds.fragmentskin.network.DataUtils;
import net.punisintendeds.fragmentskin.network.SkinUtils;
import net.punisintendeds.fragmentskin.plugin.VoiceUtils;
import net.punisintendeds.fragmentskin.utils.SkinLoader;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerInfo.class})
public abstract class SkinMixin
implements SkinLoader {
    @Shadow
    @Final
    private Map<MinecraftProfileTexture.Type, ResourceLocation> f_105299_;
    @Shadow
    @Final
    private GameProfile f_105298_;
    private Map<String, Object> data = null;
    private ResourceLocation base_skin = null;
    private ResourceLocation open_skin = null;
    private CompletableFuture<Void> currentLoadingFuture = CompletableFuture.completedFuture(null);

    @Shadow
    protected abstract void m_105341_();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fragmentskin$loadSkin() {
        SkinMixin skinMixin = this;
        synchronized (skinMixin) {
            this.currentLoadingFuture = this.currentLoadingFuture.thenCompose(ignored -> this.loadSkinAsync());
        }
    }

    private CompletableFuture<Void> loadSkinAsync() {
        return CompletableFuture.runAsync(() -> {
            CompletableFuture skinFuture = new CompletableFuture();
            CompletableFuture dataFuture = new CompletableFuture();
            SkinUtils.getSkin(this.f_105298_.getId(), "close", identifier -> {
                this.base_skin = this.getSkin((ResourceLocation)identifier);
                skinFuture.complete(null);
            });
            DataUtils.get(this.f_105298_.getId(), stringObjectMap -> {
                this.data = stringObjectMap;
                dataFuture.complete(null);
            });
            try {
                CompletableFuture.allOf(skinFuture, dataFuture).get();
                if (DataUtils.getBooleanValue(this.data, "isMouth", false)) {
                    CompletableFuture mouthFuture = new CompletableFuture();
                    SkinUtils.getSkin(this.f_105298_.getId(), "open", identifier -> {
                        this.open_skin = this.getSkin((ResourceLocation)identifier);
                        mouthFuture.complete(null);
                    });
                    mouthFuture.get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
    }

    @Inject(method={"getTabListDisplayName"}, at={@At(value="HEAD")}, cancellable=true)
    private void Name(CallbackInfoReturnable<Component> cir) {
        String name = DataUtils.getStringValue(this.data, "displayName", null);
        if (name != null) {
            cir.setReturnValue((Object)Component.m_237113_((String)name));
        }
    }

    @Inject(method={"getModelName"}, at={@At(value="HEAD")}, cancellable=true)
    private void Model(CallbackInfoReturnable<String> cir) {
        if (this.data == null) {
            cir.setReturnValue((Object)"slim");
            return;
        }
        boolean notSlim = DataUtils.getBooleanValue(this.data, "notSlim", false);
        if (notSlim) {
            cir.setReturnValue((Object)"default");
        } else {
            cir.setReturnValue((Object)"slim");
        }
    }

    @Inject(method={"getSkinLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void Skin(CallbackInfoReturnable<ResourceLocation> cir) {
        if (this.base_skin != null) {
            cir.setReturnValue((Object)this.selectedSkin());
        } else {
            this.m_105341_();
            this.base_skin = (ResourceLocation)MoreObjects.firstNonNull((Object)this.f_105299_.get(MinecraftProfileTexture.Type.SKIN), (Object)DefaultPlayerSkin.m_118627_((UUID)this.f_105298_.getId()));
            this.fragmentskin$loadSkin();
            cir.setReturnValue((Object)this.base_skin);
        }
    }

    private ResourceLocation selectedSkin() {
        if (VoiceUtils.getVoice(this.f_105298_.getId()) && DataUtils.getBooleanValue(this.data, "isMouth", false)) {
            if (this.open_skin != null) {
                return this.open_skin;
            }
            return this.base_skin;
        }
        return this.base_skin;
    }

    private ResourceLocation getSkin(ResourceLocation skin) {
        if (skin != null) {
            return skin;
        }
        this.m_105341_();
        return (ResourceLocation)MoreObjects.firstNonNull((Object)this.f_105299_.get(MinecraftProfileTexture.Type.SKIN), (Object)DefaultPlayerSkin.m_118627_((UUID)this.f_105298_.getId()));
    }
}

