/*
 * Decompiled with CFR 0.152.
 */
package net.punisintendeds.fragmentlibs.client.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.punisintendeds.fragmentlibs.FragmentLibs;
import org.joml.Matrix4f;

public class HudRenderer {
    private static final ResourceLocation texture = FragmentLibs.id("textures/gui/hud.png");
    private static final ResourceLocation texture_inverse = FragmentLibs.id("textures/gui/hud_inverse.png");
    private static final float texSize = 16.0f;

    public static void renderFrame(GuiGraphics context, float x1, float y1, float x2, float y2, Color borderColor, Color fillColor, float thickness) {
        HudRenderer.renderFrame(context, x1, y1, x2, y2, borderColor, fillColor, thickness, false);
    }

    public static void renderFrame(GuiGraphics context, float x1, float y1, float x2, float y2, Color borderColor, Color fillColor, float thickness, boolean inversed) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = context.m_280168_().m_85850_().m_252922_();
        float texSize = 16.0f;
        float width = x2 - x1;
        float height = y2 - y1;
        thickness = 2.0f * thickness;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        if (fillColor != null) {
            if (inversed) {
                fillColor = borderColor;
            }
            RenderSystem.setShaderColor((float)((float)fillColor.getRed() / 255.0f), (float)((float)fillColor.getGreen() / 255.0f), (float)((float)fillColor.getBlue() / 255.0f), (float)((float)fillColor.getAlpha() / 255.0f));
            BufferBuilder fillBuffer = Tesselator.m_85913_().m_85915_();
            fillBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            HudRenderer.drawQuad(fillBuffer, matrix4f, x1 + thickness, y1 + thickness, width - thickness * 2.0f, height - thickness * 2.0f, 1.0f, 1.0f, 2.0f, 2.0f, texSize);
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)fillBuffer.m_231175_());
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)(inversed ? texture_inverse : texture));
        RenderSystem.setShaderColor((float)((float)borderColor.getRed() / 255.0f), (float)((float)borderColor.getGreen() / 255.0f), (float)((float)borderColor.getBlue() / 255.0f), (float)((float)borderColor.getAlpha() / 255.0f));
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        HudRenderer.drawQuad(bufferBuilder, matrix4f, x1, y1, thickness, thickness, 0.0f, 0.0f, 2.0f, 2.0f, texSize);
        HudRenderer.drawQuad(bufferBuilder, matrix4f, x2 - thickness, y1, thickness, thickness, 5.0f, 0.0f, 7.0f, 2.0f, texSize);
        HudRenderer.drawQuad(bufferBuilder, matrix4f, x1, y2 - thickness, thickness, thickness, 0.0f, 5.0f, 2.0f, 7.0f, texSize);
        HudRenderer.drawQuad(bufferBuilder, matrix4f, x2 - thickness, y2 - thickness, thickness, thickness, 5.0f, 5.0f, 7.0f, 7.0f, texSize);
        HudRenderer.drawQuad(bufferBuilder, matrix4f, x1 + thickness, y1, width - thickness * 2.0f, thickness, 3.0f, 0.0f, 4.0f, 2.0f, texSize);
        HudRenderer.drawQuad(bufferBuilder, matrix4f, x1 + thickness, y2 - thickness, width - thickness * 2.0f, thickness, 3.0f, 5.0f, 4.0f, 7.0f, texSize);
        HudRenderer.drawQuad(bufferBuilder, matrix4f, x1, y1 + thickness, thickness, height - thickness * 2.0f, 0.0f, 3.0f, 2.0f, 4.0f, texSize);
        HudRenderer.drawQuad(bufferBuilder, matrix4f, x2 - thickness, y1 + thickness, thickness, height - thickness * 2.0f, 5.0f, 3.0f, 7.0f, 4.0f, texSize);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawQuad(BufferBuilder buffer, Matrix4f matrix, float x, float y, float w, float h, float u1, float v1, float u2, float v2, float texSize) {
        buffer.m_252986_(matrix, x, y, 0.0f).m_7421_(u1 / texSize, v1 / texSize).m_5752_();
        buffer.m_252986_(matrix, x, y + h, 0.0f).m_7421_(u1 / texSize, v2 / texSize).m_5752_();
        buffer.m_252986_(matrix, x + w, y + h, 0.0f).m_7421_(u2 / texSize, v2 / texSize).m_5752_();
        buffer.m_252986_(matrix, x + w, y, 0.0f).m_7421_(u2 / texSize, v1 / texSize).m_5752_();
    }
}

