/*
 * Decompiled with CFR 0.152.
 */
package net.punisintendeds.fragmentlibs.client.obj;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.phys.Vec2;
import net.punisintendeds.fragmentlibs.client.obj.Face;
import net.punisintendeds.fragmentlibs.client.obj.ObjModel;
import net.punisintendeds.fragmentlibs.client.obj.Vertex;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ObjRenderer {
    public static void render(ObjModel model, PoseStack matrices, MultiBufferSource vertexConsumer, RenderType layer, int light) {
        model.faces.forEach(face -> ObjRenderer.renderFace(face, matrices, vertexConsumer, layer, light, null));
    }

    public static void render(ObjModel model, PoseStack matrices, MultiBufferSource vertexConsumer, RenderType layer, int light, Color color) {
        model.faces.forEach(face -> ObjRenderer.renderFace(face, matrices, vertexConsumer, layer, light, color));
    }

    private static void renderFace(Face face, PoseStack matrices, MultiBufferSource vertexConsumer, RenderType layer, int light, @Nullable Color color) {
        VertexConsumer buffer = vertexConsumer.m_6299_(layer);
        int vertexCount = face.vertices().size();
        if (vertexCount == 4) {
            ObjRenderer.renderQuad(face, matrices, buffer, light, color);
        } else if (vertexCount == 3) {
            ObjRenderer.renderTriangle(face, matrices, buffer, light, color);
        } else {
            throw new RuntimeException("Face has invalid number of vertices. Supported vertex counts are 3 and 4.");
        }
    }

    private static void renderTriangle(Face face, PoseStack poseStack, VertexConsumer buffer, int packedLight, @Nullable Color color) {
        face.vertices().forEach(vertex -> ObjRenderer.addVertex(buffer, vertex, poseStack, packedLight, color));
        ObjRenderer.addVertex(buffer, face.vertices().get(0), poseStack, packedLight, color);
    }

    private static void renderQuad(Face face, PoseStack poseStack, VertexConsumer buffer, int packedLight, @Nullable Color color) {
        face.vertices().forEach(vertex -> ObjRenderer.addVertex(buffer, vertex, poseStack, packedLight, color));
    }

    private static void addVertex(VertexConsumer buffer, Vertex vertex, PoseStack poseStack, int packedLight, @Nullable Color color) {
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        Vector3f pos = vertex.position();
        Vector3f normal = vertex.normal();
        Vec2 uv = vertex.uv();
        if (color == null) {
            color = new Color(255, 255, 255, 255);
        }
        buffer.m_252986_(pose, pos.x(), pos.y(), pos.z()).m_85950_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f).m_7421_(uv.f_82470_, -uv.f_82471_).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMatrix, normal.x(), normal.y(), normal.z()).m_5752_();
    }

    private static Vector3f getCentroid(Face face) {
        Vector3f centroid = new Vector3f();
        for (Vertex vertex : face.vertices()) {
            centroid.add((Vector3fc)vertex.position());
        }
        centroid.div((float)face.vertices().size());
        return centroid;
    }
}

