/*
 * Decompiled with CFR 0.152.
 */
package net.punisintendeds.fragmentlibs.client.obj;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.phys.Vec2;
import net.punisintendeds.fragmentlibs.client.obj.Face;
import net.punisintendeds.fragmentlibs.client.obj.Vertex;
import org.joml.Vector3f;

public class ObjParser {
    public List<Vector3f> vertices = new ArrayList<Vector3f>();
    public List<Vector3f> normals = new ArrayList<Vector3f>();
    public List<Vec2> uvs = new ArrayList<Vec2>();
    public List<Face> faces = new ArrayList<Face>();

    public void parseObjFile(Resource resource) throws IOException {
        String line;
        InputStream inputStream = resource.m_215507_();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            float z;
            String[] tokens;
            if (line.startsWith("v ")) {
                tokens = line.split(" ");
                float x = Float.parseFloat(tokens[1]);
                float y = Float.parseFloat(tokens[2]);
                z = Float.parseFloat(tokens[3]);
                this.vertices.add(new Vector3f(x, y, z));
                continue;
            }
            if (line.startsWith("vn ")) {
                tokens = line.split(" ");
                float x = Float.parseFloat(tokens[1]);
                float y = Float.parseFloat(tokens[2]);
                z = Float.parseFloat(tokens[3]);
                this.normals.add(new Vector3f(x, y, z));
                continue;
            }
            if (line.startsWith("vt ")) {
                tokens = line.split(" ");
                float u = Float.parseFloat(tokens[1]);
                float v = Float.parseFloat(tokens[2]);
                this.uvs.add(new Vec2(u, v));
                continue;
            }
            if (!line.startsWith("f ")) continue;
            tokens = line.split(" ");
            ArrayList<Vertex> faceVertices = new ArrayList<Vertex>();
            for (int i = 1; i < tokens.length; ++i) {
                String[] parts = tokens[i].split("/");
                int vertexIndex = Integer.parseInt(parts[0]) - 1;
                int textureIndex = parts.length > 1 && !parts[1].isEmpty() ? Integer.parseInt(parts[1]) - 1 : 0;
                int normalIndex = parts.length > 2 ? Integer.parseInt(parts[2]) - 1 : 0;
                Vector3f position = this.vertices.get(vertexIndex);
                Vector3f normal = this.normals.get(normalIndex);
                Vec2 uv = this.uvs.get(textureIndex);
                Vertex vertex = new Vertex(position, normal, uv);
                faceVertices.add(vertex);
            }
            Face face = new Face(faceVertices);
            this.faces.add(face);
        }
        reader.close();
    }

    public ArrayList<Face> getFaces() {
        return (ArrayList)this.faces;
    }
}

