/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.visualization;

import dev.engine_room.flywheel.api.visual.Effect;
import dev.engine_room.flywheel.api.visualization.BlockEntityVisualizer;
import dev.engine_room.flywheel.api.visualization.EntityVisualizer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.api.visualization.VisualizerRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public final class VisualizationHelper {
    private VisualizationHelper() {
    }

    public static void queueAdd(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }
        manager.effects().queueAdd(effect);
    }

    public static void queueRemove(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }
        manager.effects().queueRemove(effect);
    }

    public static void queueUpdate(BlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        VisualizationManager manager = VisualizationManager.get((LevelAccessor)level);
        if (manager == null) {
            return;
        }
        manager.blockEntities().queueUpdate(blockEntity);
    }

    public static void queueUpdate(Entity entity) {
        Level level = entity.m_9236_();
        VisualizationManager manager = VisualizationManager.get((LevelAccessor)level);
        if (manager == null) {
            return;
        }
        manager.entities().queueUpdate(entity);
    }

    public static void queueUpdate(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }
        manager.effects().queueUpdate(effect);
    }

    @Nullable
    public static <T extends BlockEntity> BlockEntityVisualizer<? super T> getVisualizer(T blockEntity) {
        return VisualizerRegistry.getVisualizer(blockEntity.m_58903_());
    }

    @Nullable
    public static <T extends Entity> EntityVisualizer<? super T> getVisualizer(T entity) {
        return VisualizerRegistry.getVisualizer(entity.m_6095_());
    }

    public static <T extends BlockEntity> boolean canVisualize(T blockEntity) {
        return VisualizationHelper.getVisualizer(blockEntity) != null;
    }

    public static <T extends Entity> boolean canVisualize(T entity) {
        return VisualizationHelper.getVisualizer(entity) != null;
    }

    public static <T extends BlockEntity> boolean skipVanillaRender(T blockEntity) {
        BlockEntityVisualizer<T> visualizer = VisualizationHelper.getVisualizer(blockEntity);
        if (visualizer == null) {
            return false;
        }
        return visualizer.skipVanillaRender(blockEntity);
    }

    public static <T extends Entity> boolean skipVanillaRender(T entity) {
        EntityVisualizer<T> visualizer = VisualizationHelper.getVisualizer(entity);
        if (visualizer == null) {
            return false;
        }
        return visualizer.skipVanillaRender(entity);
    }

    public static <T extends BlockEntity> boolean tryAddBlockEntity(T blockEntity) {
        Level level = blockEntity.m_58904_();
        VisualizationManager manager = VisualizationManager.get((LevelAccessor)level);
        if (manager == null) {
            return false;
        }
        BlockEntityVisualizer<T> visualizer = VisualizationHelper.getVisualizer(blockEntity);
        if (visualizer == null) {
            return false;
        }
        manager.blockEntities().queueAdd(blockEntity);
        return visualizer.skipVanillaRender(blockEntity);
    }
}

