/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.visual.util;

import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.lib.visual.util.InstanceRecycler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class SmartRecycler<K, I extends Instance> {
    private final Function<K, I> factory;
    private final Map<K, InstanceRecycler<I>> recyclers = new HashMap<K, InstanceRecycler<I>>();

    public SmartRecycler(Function<K, I> factory) {
        this.factory = factory;
    }

    public void resetCount() {
        this.recyclers.values().forEach(InstanceRecycler::resetCount);
    }

    public I get(K key) {
        return this.recyclers.computeIfAbsent(key, k -> new InstanceRecycler<Instance>(() -> (Instance)this.factory.apply(k))).get();
    }

    public void discardExtra() {
        this.recyclers.values().forEach(InstanceRecycler::discardExtra);
    }

    public void delete() {
        this.recyclers.values().forEach(InstanceRecycler::delete);
        this.recyclers.clear();
    }
}

