/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.visual.component;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.vertex.MutableVertexList;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.material.Materials;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.model.QuadMesh;
import dev.engine_room.flywheel.lib.model.SingleMeshModel;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import dev.engine_room.flywheel.lib.visual.component.EntityComponent;
import dev.engine_room.flywheel.lib.visual.util.SmartRecycler;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public final class FireComponent
implements EntityComponent {
    private static final Material FIRE_MATERIAL = SimpleMaterial.builderOf(Materials.CUTOUT_UNSHADED_BLOCK).backfaceCulling(false).build();
    private static final RendererReloadCache<net.minecraft.client.resources.model.Material, Model> FIRE_MODELS = new RendererReloadCache<net.minecraft.client.resources.model.Material, Model>(texture -> new SingleMeshModel(new FireMesh(texture.m_119204_()), FIRE_MATERIAL));
    private final VisualizationContext context;
    private final Entity entity;
    private final PoseStack stack = new PoseStack();
    private final SmartRecycler<Model, TransformedInstance> recycler;

    public FireComponent(VisualizationContext context, Entity entity) {
        this.context = context;
        this.entity = entity;
        this.recycler = new SmartRecycler<Model, TransformedInstance>(this::createInstance);
    }

    private TransformedInstance createInstance(Model model) {
        TransformedInstance instance = this.context.instancerProvider().instancer(InstanceTypes.TRANSFORMED, model).createInstance();
        instance.light(240);
        instance.setChanged();
        return instance;
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        this.recycler.resetCount();
        if (this.entity.m_6051_()) {
            this.setupInstances(context);
        }
        this.recycler.discardExtra();
    }

    private void setupInstances(DynamicVisual.Context context) {
        double entityX = Mth.m_14139_((double)context.partialTick(), (double)this.entity.f_19790_, (double)this.entity.m_20185_());
        double entityY = Mth.m_14139_((double)context.partialTick(), (double)this.entity.f_19791_, (double)this.entity.m_20186_());
        double entityZ = Mth.m_14139_((double)context.partialTick(), (double)this.entity.f_19792_, (double)this.entity.m_20189_());
        Vec3i renderOrigin = this.context.renderOrigin();
        float scale = this.entity.m_20205_() * 1.4f;
        float maxHeight = this.entity.m_20206_() / scale;
        float width = 1.0f;
        float y = 0.0f;
        float z = 0.0f;
        this.stack.m_166856_();
        this.stack.m_85837_(entityX - (double)renderOrigin.m_123341_(), entityY - (double)renderOrigin.m_123342_(), entityZ - (double)renderOrigin.m_123343_());
        this.stack.m_85841_(scale, scale, scale);
        this.stack.m_252781_(Axis.f_252436_.m_252977_(-context.camera().m_90590_()));
        this.stack.m_252880_(0.0f, 0.0f, -0.3f + (float)((int)maxHeight) * 0.02f);
        int i = 0;
        while (y < maxHeight) {
            TransformedInstance instance = ((TransformedInstance)this.recycler.get(FIRE_MODELS.get(i % 2 == 0 ? ModelBakery.f_119219_ : ModelBakery.f_119220_)).setTransform(this.stack).scaleX(width)).translate(0.0f, y, z);
            if (i / 2 % 2 == 0) {
                instance.scaleX(-1.0f);
            }
            instance.setChanged();
            y += 0.45f;
            width *= 0.9f;
            z += 0.03f;
            ++i;
        }
    }

    @Override
    public void delete() {
        this.recycler.delete();
    }

    private record FireMesh(TextureAtlasSprite sprite) implements QuadMesh
    {
        private static final Vector4fc BOUNDING_SPHERE = new Vector4f(0.0f, 0.5f, 0.0f, Mth.f_13994_ * 0.5f);

        @Override
        public int vertexCount() {
            return 4;
        }

        @Override
        public void write(MutableVertexList vertexList) {
            float u0 = this.sprite.m_118409_();
            float v0 = this.sprite.m_118411_();
            float u1 = this.sprite.m_118410_();
            float v1 = this.sprite.m_118412_();
            FireMesh.writeVertex(vertexList, 0, 0.5f, 0.0f, u1, v1);
            FireMesh.writeVertex(vertexList, 1, -0.5f, 0.0f, u0, v1);
            FireMesh.writeVertex(vertexList, 2, -0.5f, 1.4f, u0, v0);
            FireMesh.writeVertex(vertexList, 3, 0.5f, 1.4f, u1, v0);
        }

        private static void writeVertex(MutableVertexList vertexList, int i, float x, float y, float u, float v) {
            vertexList.x(i, x);
            vertexList.y(i, y);
            vertexList.z(i, 0.0f);
            vertexList.r(i, 1.0f);
            vertexList.g(i, 1.0f);
            vertexList.b(i, 1.0f);
            vertexList.u(i, u);
            vertexList.v(i, v);
            vertexList.light(i, 240);
            vertexList.normalX(i, 0.0f);
            vertexList.normalY(i, 1.0f);
            vertexList.normalZ(i, 0.0f);
        }

        @Override
        public Vector4fc boundingSphere() {
            return BOUNDING_SPHERE;
        }
    }
}

