/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.visual;

import dev.engine_room.flywheel.lib.math.MoreMath;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.joml.FrustumIntersection;

public class EntityVisibilityTester {
    private final Entity entity;
    private final Vec3i renderOrigin;
    private final float scale;
    @Nullable
    private AABB lastVisibleAABB;

    public EntityVisibilityTester(Entity entity, Vec3i renderOrigin, float scale) {
        this.entity = entity;
        this.renderOrigin = renderOrigin;
        this.scale = scale;
    }

    public boolean check(FrustumIntersection frustum) {
        boolean visible;
        AABB aabb = this.entity.m_6921_();
        boolean bl = visible = this.lastVisibleAABB == null;
        if (!visible) {
            visible = this.adjustAndTestAABB(frustum, aabb);
        }
        if (!visible && this.lastVisibleAABB != aabb) {
            visible = this.adjustAndTestAABB(frustum, this.lastVisibleAABB);
        }
        if (visible) {
            this.lastVisibleAABB = aabb;
        }
        return visible;
    }

    private boolean adjustAndTestAABB(FrustumIntersection frustum, AABB aabb) {
        float x = (float)Mth.m_14139_((double)0.5, (double)aabb.f_82288_, (double)aabb.f_82291_) - (float)this.renderOrigin.m_123341_();
        float y = (float)Mth.m_14139_((double)0.5, (double)aabb.f_82289_, (double)aabb.f_82292_) - (float)this.renderOrigin.m_123342_();
        float z = (float)Mth.m_14139_((double)0.5, (double)aabb.f_82290_, (double)aabb.f_82293_) - (float)this.renderOrigin.m_123343_();
        float maxSize = (float)Math.max(aabb.m_82362_(), Math.max(aabb.m_82376_(), aabb.m_82385_()));
        return frustum.testSphere(x, y, z, maxSize * MoreMath.SQRT_3_OVER_2 * this.scale);
    }
}

