/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.visual;

import dev.engine_room.flywheel.api.visual.BlockEntityVisual;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.LightUpdatedVisual;
import dev.engine_room.flywheel.api.visual.SectionTrackedVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.math.MoreMath;
import dev.engine_room.flywheel.lib.visual.AbstractVisual;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Iterator;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.joml.FrustumIntersection;

public abstract class AbstractBlockEntityVisual<T extends BlockEntity>
extends AbstractVisual
implements BlockEntityVisual<T>,
LightUpdatedVisual {
    protected final T blockEntity;
    protected final BlockPos pos;
    protected final BlockPos visualPos;
    protected final BlockState blockState;
    protected @UnknownNullability SectionTrackedVisual.SectionCollector lightSections;

    public AbstractBlockEntityVisual(VisualizationContext ctx, T blockEntity, float partialTick) {
        super(ctx, blockEntity.m_58904_(), partialTick);
        this.blockEntity = blockEntity;
        this.pos = blockEntity.m_58899_();
        this.blockState = blockEntity.m_58900_();
        this.visualPos = this.pos.m_121996_(ctx.renderOrigin());
    }

    @Override
    public void setSectionCollector(SectionTrackedVisual.SectionCollector sectionCollector) {
        this.lightSections = sectionCollector;
        this.lightSections.sections(LongSet.of((long)SectionPos.m_175568_((BlockPos)this.pos)));
    }

    public BlockPos getVisualPosition() {
        return this.visualPos;
    }

    public boolean isVisible(FrustumIntersection frustum) {
        float x = (float)this.visualPos.m_123341_() + 0.5f;
        float y = (float)this.visualPos.m_123342_() + 0.5f;
        float z = (float)this.visualPos.m_123343_() + 0.5f;
        return frustum.testSphere(x, y, z, MoreMath.SQRT_3_OVER_2);
    }

    public boolean doDistanceLimitThisFrame(DynamicVisual.Context context) {
        return !context.limiter().shouldUpdate(this.pos.m_203193_((Position)context.camera().m_90583_()));
    }

    protected int computePackedLight() {
        return LevelRenderer.m_109541_((BlockAndTintGetter)this.level, (BlockPos)this.pos);
    }

    protected void relight(BlockPos pos, FlatLit ... instances) {
        FlatLit.relight(LevelRenderer.m_109541_((BlockAndTintGetter)this.level, (BlockPos)pos), instances);
    }

    protected void relight(FlatLit ... instances) {
        this.relight(this.pos, instances);
    }

    protected void relight(BlockPos pos, Iterator<@Nullable FlatLit> instances) {
        FlatLit.relight(LevelRenderer.m_109541_((BlockAndTintGetter)this.level, (BlockPos)pos), instances);
    }

    protected void relight(Iterator<@Nullable FlatLit> instances) {
        this.relight(this.pos, instances);
    }

    protected void relight(BlockPos pos, Iterable<@Nullable FlatLit> instances) {
        FlatLit.relight(LevelRenderer.m_109541_((BlockAndTintGetter)this.level, (BlockPos)pos), instances);
    }

    protected void relight(Iterable<@Nullable FlatLit> instances) {
        this.relight(this.pos, instances);
    }
}

