/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.util;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class ResourceUtil {
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.id.invalid"));

    private ResourceUtil() {
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation("flywheel", path);
    }

    public static ResourceLocation parseFlywheelDefault(String location) {
        String namespace = "flywheel";
        String path = location;
        int i = location.indexOf(58);
        if (i >= 0) {
            path = location.substring(i + 1);
            if (i >= 1) {
                namespace = location.substring(0, i);
            }
        }
        return new ResourceLocation(namespace, path);
    }

    public static ResourceLocation readFlywheelDefault(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && ResourceLocation.m_135816_((char)reader.peek())) {
            reader.skip();
        }
        String s = reader.getString().substring(i, reader.getCursor());
        try {
            return ResourceUtil.parseFlywheelDefault(s);
        }
        catch (ResourceLocationException resourcelocationexception) {
            reader.setCursor(i);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static String toDebugFileNameNoExtension(ResourceLocation resourceLocation) {
        String stringLoc = resourceLocation.m_179910_();
        return stringLoc.substring(0, stringLoc.lastIndexOf(46));
    }
}

