/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.transform;

import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3fc;
import org.joml.Vector3ic;

public interface Translate<Self extends Translate<Self>> {
    public static final float CENTER = 0.5f;

    public Self translate(float var1, float var2, float var3);

    default public Self translate(double x, double y, double z) {
        return this.translate((float)x, (float)y, (float)z);
    }

    default public Self translate(float v) {
        return this.translate(v, v, v);
    }

    default public Self translateX(float x) {
        return this.translate(x, 0.0f, 0.0f);
    }

    default public Self translateY(float y) {
        return this.translate(0.0f, y, 0.0f);
    }

    default public Self translateZ(float z) {
        return this.translate(0.0f, 0.0f, z);
    }

    default public Self translate(Vec3i vec) {
        return this.translate(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    default public Self translate(Vector3ic vec) {
        return this.translate(vec.x(), vec.y(), vec.z());
    }

    default public Self translate(Vector3fc vec) {
        return this.translate(vec.x(), vec.y(), vec.z());
    }

    default public Self translate(Vec3 vec) {
        return this.translate(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    default public Self translateBack(float x, float y, float z) {
        return this.translate(-x, -y, -z);
    }

    default public Self translateBack(double x, double y, double z) {
        return this.translate(-x, -y, -z);
    }

    default public Self translateBack(float v) {
        return this.translate(-v);
    }

    default public Self translateBack(Vec3i vec) {
        return this.translateBack(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    default public Self translateBack(Vector3ic vec) {
        return this.translateBack(vec.x(), vec.y(), vec.z());
    }

    default public Self translateBack(Vector3fc vec) {
        return this.translateBack(vec.x(), vec.y(), vec.z());
    }

    default public Self translateBack(Vec3 vec) {
        return this.translateBack(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    default public Self center() {
        return this.translate(0.5f);
    }

    default public Self uncenter() {
        return this.translate(-0.5f);
    }

    default public Self nudge(int seed) {
        long randomBits = (long)seed * 31L * 493286711L;
        randomBits = randomBits * randomBits * 4392167121L + randomBits * 98761L;
        float xNudge = (((float)(randomBits >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float yNudge = (((float)(randomBits >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float zNudge = (((float)(randomBits >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        return this.translate(xNudge, yNudge, zNudge);
    }
}

