/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.transform;

import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public interface Rotate<Self extends Rotate<Self>> {
    public Self rotate(Quaternionfc var1);

    default public Self rotate(AxisAngle4f axisAngle) {
        return this.rotate((Quaternionfc)new Quaternionf(axisAngle));
    }

    default public Self rotate(float radians, float axisX, float axisY, float axisZ) {
        if (radians == 0.0f) {
            return this.self();
        }
        return this.rotate((Quaternionfc)new Quaternionf().setAngleAxis(radians, axisX, axisY, axisZ));
    }

    default public Self rotate(float radians, Axis axis) {
        if (radians == 0.0f) {
            return this.self();
        }
        return this.rotate((Quaternionfc)axis.m_252961_(radians));
    }

    default public Self rotate(float radians, Vector3fc axis) {
        return this.rotate(radians, axis.x(), axis.y(), axis.z());
    }

    default public Self rotate(float radians, Direction axis) {
        return this.rotate(radians, axis.m_122429_(), axis.m_122430_(), axis.m_122431_());
    }

    default public Self rotate(float radians, Direction.Axis axis) {
        return this.rotate(radians, Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
    }

    default public Self rotateDegrees(float degrees, float axisX, float axisY, float axisZ) {
        return this.rotate((float)Math.PI / 180 * degrees, axisX, axisY, axisZ);
    }

    default public Self rotateDegrees(float degrees, Axis axis) {
        return this.rotate((float)Math.PI / 180 * degrees, axis);
    }

    default public Self rotateDegrees(float degrees, Vector3fc axis) {
        return this.rotate((float)Math.PI / 180 * degrees, axis);
    }

    default public Self rotateDegrees(float degrees, Direction axis) {
        return this.rotate((float)Math.PI / 180 * degrees, axis);
    }

    default public Self rotateDegrees(float degrees, Direction.Axis axis) {
        return this.rotate((float)Math.PI / 180 * degrees, axis);
    }

    default public Self rotateX(float radians) {
        return this.rotate(radians, Axis.f_252529_);
    }

    default public Self rotateY(float radians) {
        return this.rotate(radians, Axis.f_252436_);
    }

    default public Self rotateZ(float radians) {
        return this.rotate(radians, Axis.f_252403_);
    }

    default public Self rotateXDegrees(float degrees) {
        return this.rotateX((float)Math.PI / 180 * degrees);
    }

    default public Self rotateYDegrees(float degrees) {
        return this.rotateY((float)Math.PI / 180 * degrees);
    }

    default public Self rotateZDegrees(float degrees) {
        return this.rotateZ((float)Math.PI / 180 * degrees);
    }

    default public Self rotateToFace(Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> this.rotateXDegrees(-90.0f);
            case Direction.UP -> this.rotateXDegrees(90.0f);
            case Direction.NORTH -> this.self();
            case Direction.SOUTH -> this.rotateYDegrees(180.0f);
            case Direction.WEST -> this.rotateYDegrees(90.0f);
            case Direction.EAST -> this.rotateYDegrees(270.0f);
        };
    }

    default public Self rotateTo(float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        return this.rotate((Quaternionfc)new Quaternionf().rotationTo(fromX, fromY, fromZ, toX, toY, toZ));
    }

    default public Self rotateTo(Vector3fc from, Vector3fc to) {
        return this.rotateTo(from.x(), from.y(), from.z(), to.x(), to.y(), to.z());
    }

    default public Self rotateTo(Direction from, Direction to) {
        return this.rotateTo(from.m_122429_(), from.m_122430_(), from.m_122431_(), to.m_122429_(), to.m_122430_(), to.m_122431_());
    }

    default public Self self() {
        return (Self)this;
    }
}

