/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.part;

import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Mesh;
import dev.engine_room.flywheel.lib.model.RetexturedMesh;
import dev.engine_room.flywheel.lib.model.SingleMeshModel;
import dev.engine_room.flywheel.lib.model.part.MeshTree;
import dev.engine_room.flywheel.lib.model.part.ModelTree;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.jetbrains.annotations.Nullable;

public final class ModelTrees {
    private static final RendererReloadCache<ModelTreeKey, ModelTree> CACHE = new RendererReloadCache<ModelTreeKey, ModelTree>(k -> {
        ModelTree tree = ModelTrees.convert("", MeshTree.of(k.layer), k.pathsToPrune, k.texture != null ? k.texture.m_119204_() : null, k.material);
        if (tree == null) {
            throw new IllegalArgumentException("Cannot prune root node!");
        }
        return tree;
    });

    private ModelTrees() {
    }

    public static ModelTree of(ModelLayerLocation layer, Material material) {
        return CACHE.get(new ModelTreeKey(layer, Collections.emptySet(), null, material));
    }

    public static ModelTree of(ModelLayerLocation layer, net.minecraft.client.resources.model.Material texture, Material material) {
        return CACHE.get(new ModelTreeKey(layer, Collections.emptySet(), texture, material));
    }

    public static ModelTree of(ModelLayerLocation layer, Set<String> pathsToPrune, Material material) {
        return CACHE.get(new ModelTreeKey(layer, Set.copyOf(pathsToPrune), null, material));
    }

    public static ModelTree of(ModelLayerLocation layer, Set<String> pathsToPrune, net.minecraft.client.resources.model.Material texture, Material material) {
        return CACHE.get(new ModelTreeKey(layer, Set.copyOf(pathsToPrune), texture, material));
    }

    @Nullable
    private static ModelTree convert(String path, MeshTree meshTree, Set<String> pathsToPrune, @Nullable TextureAtlasSprite sprite, Material material) {
        if (pathsToPrune.contains(path)) {
            return null;
        }
        SingleMeshModel model = null;
        Mesh mesh = meshTree.mesh();
        if (mesh != null) {
            if (sprite != null) {
                mesh = new RetexturedMesh(mesh, sprite);
            }
            model = new SingleMeshModel(mesh, material);
        }
        HashMap<String, ModelTree> children = new HashMap<String, ModelTree>();
        String pathSlash = path + "/";
        for (int i = 0; i < meshTree.childCount(); ++i) {
            String childName = meshTree.childName(i);
            ModelTree child = ModelTrees.convert(pathSlash + childName, meshTree.child(i), pathsToPrune, sprite, material);
            if (child == null) continue;
            children.put(childName, child);
        }
        return new ModelTree(model, meshTree.initialPose(), children);
    }

    private record ModelTreeKey(ModelLayerLocation layer, Set<String> pathsToPrune, @Nullable net.minecraft.client.resources.model.Material texture, Material material) {
    }
}

