/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.part;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.engine_room.flywheel.api.model.Mesh;
import dev.engine_room.flywheel.lib.internal.FlwLibLink;
import dev.engine_room.flywheel.lib.memory.MemoryBlock;
import dev.engine_room.flywheel.lib.model.SimpleQuadMesh;
import dev.engine_room.flywheel.lib.model.part.VertexWriter;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import dev.engine_room.flywheel.lib.vertex.PosTexNormalVertexView;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.jetbrains.annotations.Nullable;

public final class MeshTree {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private static final PoseStack.Pose IDENTITY_POSE = new PoseStack().m_85850_();
    private static final RendererReloadCache<ModelLayerLocation, MeshTree> CACHE = new RendererReloadCache<ModelLayerLocation, MeshTree>(MeshTree::convert);
    @Nullable
    private final Mesh mesh;
    private final PartPose initialPose;
    private final MeshTree[] children;
    private final String[] childNames;

    private MeshTree(@Nullable Mesh mesh, PartPose initialPose, MeshTree[] children, String[] childNames) {
        this.mesh = mesh;
        this.initialPose = initialPose;
        this.children = children;
        this.childNames = childNames;
    }

    public static MeshTree of(ModelLayerLocation layer) {
        return CACHE.get(layer);
    }

    private static MeshTree convert(ModelLayerLocation layer) {
        EntityModelSet entityModels = Minecraft.m_91087_().m_167973_();
        ModelPart modelPart = entityModels.m_171103_(layer);
        return MeshTree.convert(modelPart, THREAD_LOCAL_OBJECTS.get());
    }

    private static MeshTree convert(ModelPart modelPart, ThreadLocalObjects objects) {
        Map<String, ModelPart> modelPartChildren = FlwLibLink.INSTANCE.getModelPartChildren(modelPart);
        Object[] childNames = (String[])modelPartChildren.keySet().toArray(String[]::new);
        Arrays.sort(childNames);
        MeshTree[] children = new MeshTree[childNames.length];
        for (int i = 0; i < childNames.length; ++i) {
            children[i] = MeshTree.convert(modelPartChildren.get(childNames[i]), objects);
        }
        return new MeshTree(MeshTree.compile(modelPart, objects), modelPart.m_233566_(), children, (String[])childNames);
    }

    @Nullable
    private static Mesh compile(ModelPart modelPart, ThreadLocalObjects objects) {
        if (modelPart.m_171326_()) {
            return null;
        }
        VertexWriter vertexWriter = objects.vertexWriter;
        FlwLibLink.INSTANCE.compileModelPart(modelPart, IDENTITY_POSE, vertexWriter, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        MemoryBlock data = vertexWriter.copyDataAndReset();
        PosTexNormalVertexView vertexView = new PosTexNormalVertexView();
        vertexView.load(data);
        return new SimpleQuadMesh(vertexView, "source=MeshTree");
    }

    @Nullable
    public Mesh mesh() {
        return this.mesh;
    }

    public PartPose initialPose() {
        return this.initialPose;
    }

    public int childCount() {
        return this.children.length;
    }

    public MeshTree child(int index) {
        return this.children[index];
    }

    public String childName(int index) {
        return this.childNames[index];
    }

    public int childIndex(String name) {
        return Arrays.binarySearch(this.childNames, name);
    }

    public boolean hasChild(String name) {
        return this.childIndex(name) >= 0;
    }

    @Nullable
    public MeshTree child(String name) {
        int index = this.childIndex(name);
        if (index < 0) {
            return null;
        }
        return this.child(index);
    }

    public MeshTree childOrThrow(String name) {
        MeshTree child = this.child(name);
        if (child == null) {
            throw new NoSuchElementException("Can't find part " + name);
        }
        return child;
    }

    private static class ThreadLocalObjects {
        public final VertexWriter vertexWriter = new VertexWriter();

        private ThreadLocalObjects() {
        }
    }
}

