/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.baked;

import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jetbrains.annotations.Nullable;

public final class VirtualLightEngine
extends LevelLightEngine {
    private final LayerLightEventListener blockListener;
    private final LayerLightEventListener skyListener;

    public VirtualLightEngine(ToIntFunction<BlockPos> blockLightFunc, ToIntFunction<BlockPos> skyLightFunc, final BlockGetter level) {
        super(new LightChunkGetter(){

            @Nullable
            public LightChunk m_6196_(int x, int z) {
                return null;
            }

            public BlockGetter m_7653_() {
                return level;
            }
        }, false, false);
        this.blockListener = new VirtualLayerLightEventListener(blockLightFunc);
        this.skyListener = new VirtualLayerLightEventListener(skyLightFunc);
    }

    public LayerLightEventListener m_75814_(LightLayer layer) {
        return layer == LightLayer.BLOCK ? this.blockListener : this.skyListener;
    }

    public int m_75831_(BlockPos pos, int amount) {
        int i = this.skyListener.m_7768_(pos) - amount;
        int j = this.blockListener.m_7768_(pos);
        return Math.max(j, i);
    }

    private static class VirtualLayerLightEventListener
    implements LayerLightEventListener {
        private final ToIntFunction<BlockPos> lightFunc;

        public VirtualLayerLightEventListener(ToIntFunction<BlockPos> lightFunc) {
            this.lightFunc = lightFunc;
        }

        public void m_7174_(BlockPos pos) {
        }

        public boolean m_75808_() {
            return false;
        }

        public int m_9323_() {
            return 0;
        }

        public void m_6191_(SectionPos pos, boolean isSectionEmpty) {
        }

        public void m_9335_(ChunkPos pos, boolean lightEnabled) {
        }

        public void m_142519_(ChunkPos pos) {
        }

        public DataLayer m_8079_(SectionPos pos) {
            return null;
        }

        public int m_7768_(BlockPos pos) {
            return this.lightFunc.applyAsInt(pos);
        }
    }
}

