/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.baked;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBufferer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import org.jetbrains.annotations.UnknownNullability;

class MeshEmitter
implements VertexConsumer {
    private final RenderType renderType;
    private final BufferBuilder bufferBuilder;
    private @UnknownNullability BakedModelBufferer.ResultConsumer resultConsumer;
    private boolean currentShade;

    MeshEmitter(RenderType renderType) {
        this.renderType = renderType;
        this.bufferBuilder = new BufferBuilder(renderType.m_110507_());
    }

    public void prepare(BakedModelBufferer.ResultConsumer resultConsumer) {
        this.resultConsumer = resultConsumer;
    }

    public void end() {
        if (this.bufferBuilder.m_85732_()) {
            this.emit();
        }
        this.resultConsumer = null;
    }

    public BufferBuilder unwrap(boolean shade) {
        this.prepareForGeometry(shade);
        return this.bufferBuilder;
    }

    private void prepareForGeometry(boolean shade) {
        if (!this.bufferBuilder.m_85732_()) {
            this.bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        } else if (shade != this.currentShade) {
            this.emit();
            this.bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        }
        this.currentShade = shade;
    }

    private void prepareForGeometry(BakedQuad quad) {
        this.prepareForGeometry(quad.m_111307_());
    }

    private void emit() {
        BufferBuilder.RenderedBuffer renderedBuffer = this.bufferBuilder.m_231168_();
        if (renderedBuffer != null) {
            this.resultConsumer.accept(this.renderType, this.currentShade, renderedBuffer);
            renderedBuffer.m_231200_();
        }
    }

    public void m_85987_(PoseStack.Pose pose, BakedQuad quad, float red, float green, float blue, int light, int overlay) {
        this.prepareForGeometry(quad);
        this.bufferBuilder.m_85987_(pose, quad, red, green, blue, light, overlay);
    }

    public void putBulkData(PoseStack.Pose pose, BakedQuad quad, float red, float green, float blue, float alpha, int light, int overlay, boolean readExistingColor) {
        this.prepareForGeometry(quad);
        this.bufferBuilder.putBulkData(pose, quad, red, green, blue, alpha, light, overlay, readExistingColor);
    }

    public void m_85995_(PoseStack.Pose pose, BakedQuad quad, float[] brightnesses, float red, float green, float blue, int[] lights, int overlay, boolean readExistingColor) {
        this.prepareForGeometry(quad);
        this.bufferBuilder.m_85995_(pose, quad, brightnesses, red, green, blue, lights, overlay, readExistingColor);
    }

    public void putBulkData(PoseStack.Pose pose, BakedQuad quad, float[] brightnesses, float red, float green, float blue, float alpha, int[] lights, int overlay, boolean readExistingColor) {
        this.prepareForGeometry(quad);
        this.bufferBuilder.putBulkData(pose, quad, brightnesses, red, green, blue, alpha, lights, overlay, readExistingColor);
    }

    public VertexConsumer m_5483_(double x, double y, double z) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer m_7421_(float u, float v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer m_7122_(int u, int v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer m_7120_(int u, int v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer m_5601_(float x, float y, float z) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public void m_5752_() {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public void m_7404_(int red, int green, int blue, int alpha) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public void m_141991_() {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }
}

