/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.baked;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.lib.model.ModelUtil;
import dev.engine_room.flywheel.lib.model.SimpleModel;
import dev.engine_room.flywheel.lib.model.SimpleQuadMesh;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBufferer;
import dev.engine_room.flywheel.lib.model.baked.BlockModelBuilder;
import dev.engine_room.flywheel.lib.model.baked.ChunkLayerSortedListBuilder;
import dev.engine_room.flywheel.lib.model.baked.MeshHelper;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public final class ForgeBlockModelBuilder
extends BlockModelBuilder {
    @Nullable
    private Function<BlockPos, ModelData> modelDataLookup;

    public ForgeBlockModelBuilder(BlockAndTintGetter level, Iterable<BlockPos> positions) {
        super(level, positions);
    }

    @Override
    public ForgeBlockModelBuilder poseStack(@Nullable PoseStack poseStack) {
        super.poseStack(poseStack);
        return this;
    }

    @Override
    public ForgeBlockModelBuilder renderFluids(boolean renderFluids) {
        super.renderFluids(renderFluids);
        return this;
    }

    @Override
    public ForgeBlockModelBuilder materialFunc(@Nullable BiFunction<RenderType, Boolean, Material> materialFunc) {
        super.materialFunc(materialFunc);
        return this;
    }

    public ForgeBlockModelBuilder modelDataLookup(@Nullable Function<BlockPos, ModelData> modelDataLookup) {
        this.modelDataLookup = modelDataLookup;
        return this;
    }

    @Override
    public SimpleModel build() {
        if (this.materialFunc == null) {
            this.materialFunc = ModelUtil::getMaterial;
        }
        if (this.modelDataLookup == null) {
            this.modelDataLookup = pos -> {
                BlockEntity blockEntity = this.level.m_7702_(pos);
                return blockEntity != null ? blockEntity.getModelData() : ModelData.EMPTY;
            };
        }
        ChunkLayerSortedListBuilder builder = ChunkLayerSortedListBuilder.getThreadLocal();
        BakedModelBufferer.bufferBlocks(this.positions.iterator(), this.level, this.poseStack, this.modelDataLookup, this.renderFluids, (renderType, shaded, data) -> {
            Material material = (Material)this.materialFunc.apply(renderType, shaded);
            if (material != null) {
                SimpleQuadMesh mesh = MeshHelper.blockVerticesToMesh(data, "source=BlockModelBuilder,renderType=" + renderType + ",shaded=" + shaded);
                builder.add(renderType, new Model.ConfiguredMesh(material, mesh));
            }
        });
        return new SimpleModel((List<Model.ConfiguredMesh>)builder.build());
    }
}

