/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.baked;

import com.google.common.collect.ImmutableList;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBufferer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.client.renderer.RenderType;

class ChunkLayerSortedListBuilder<T> {
    private static final ThreadLocal<ChunkLayerSortedListBuilder<?>> THREAD_LOCAL = ThreadLocal.withInitial(ChunkLayerSortedListBuilder::new);
    private final ObjectArrayList<T>[] lists = new ObjectArrayList[BakedModelBufferer.CHUNK_LAYER_AMOUNT];

    private ChunkLayerSortedListBuilder() {
        for (int layerIndex = 0; layerIndex < BakedModelBufferer.CHUNK_LAYER_AMOUNT; ++layerIndex) {
            ObjectArrayList list;
            this.lists[layerIndex] = list = new ObjectArrayList();
        }
    }

    public static <T> ChunkLayerSortedListBuilder<T> getThreadLocal() {
        return THREAD_LOCAL.get();
    }

    public void add(RenderType renderType, T obj) {
        int layerIndex = renderType.getChunkLayerId();
        if (layerIndex == -1) {
            throw new IllegalArgumentException("RenderType '" + renderType + "' is not a chunk layer");
        }
        ObjectArrayList<T> list = this.lists[layerIndex];
        list.add(obj);
    }

    public ImmutableList<T> build() {
        int size = 0;
        for (ObjectArrayList<T> list : this.lists) {
            size += list.size();
        }
        Object[] array = new Object[size];
        int destPos = 0;
        for (ObjectArrayList<T> list : this.lists) {
            System.arraycopy(list.elements(), 0, array, destPos, list.size());
            destPos += list.size();
            list.clear();
        }
        return ImmutableList.copyOf((Object[])array);
    }
}

