/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.memory;

import dev.engine_room.flywheel.lib.memory.AbstractMemoryBlockImpl;
import dev.engine_room.flywheel.lib.memory.FlwMemoryTracker;
import dev.engine_room.flywheel.lib.memory.MemoryBlock;
import java.lang.ref.Cleaner;

class TrackedMemoryBlockImpl
extends AbstractMemoryBlockImpl {
    final Cleaner cleaner;
    final CleaningAction cleaningAction;
    final Cleaner.Cleanable cleanable;

    TrackedMemoryBlockImpl(long ptr, long size, Cleaner cleaner) {
        super(ptr, size);
        this.cleaner = cleaner;
        this.cleaningAction = new CleaningAction(ptr, size);
        this.cleanable = cleaner.register(this, this.cleaningAction);
    }

    @Override
    public boolean isTracked() {
        return true;
    }

    @Override
    void freeInner() {
        super.freeInner();
        this.cleaningAction.freed = true;
        this.cleanable.clean();
    }

    @Override
    public MemoryBlock realloc(long size) {
        this.assertAllocated();
        TrackedMemoryBlockImpl block = new TrackedMemoryBlockImpl(FlwMemoryTracker.realloc(this.ptr, size), size, this.cleaner);
        FlwMemoryTracker._allocCpuMemory(block.size());
        this.freeInner();
        return block;
    }

    static MemoryBlock malloc(long size) {
        TrackedMemoryBlockImpl block = new TrackedMemoryBlockImpl(FlwMemoryTracker.malloc(size), size, CLEANER);
        FlwMemoryTracker._allocCpuMemory(block.size());
        return block;
    }

    static MemoryBlock calloc(long num, long size) {
        TrackedMemoryBlockImpl block = new TrackedMemoryBlockImpl(FlwMemoryTracker.calloc(num, size), num * size, CLEANER);
        FlwMemoryTracker._allocCpuMemory(block.size());
        return block;
    }

    static class CleaningAction
    implements Runnable {
        final long ptr;
        final long size;
        boolean freed;

        CleaningAction(long ptr, long size) {
            this.ptr = ptr;
            this.size = size;
        }

        @Override
        public void run() {
            if (!this.freed) {
                FlwMemoryTracker.free(this.ptr);
                FlwMemoryTracker._freeCpuMemory(this.size);
            }
        }
    }
}

