/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.math;

public final class MoreMath {
    public static final float SQRT_3_OVER_2 = (float)(Math.sqrt(3.0) / 2.0);

    private MoreMath() {
    }

    public static int align32(int size) {
        return size + 31 & 0xFFFFFFE0;
    }

    public static int align16(int size) {
        return size + 15 & 0xFFFFFFF0;
    }

    public static int align4(int size) {
        return size + 3 & 0xFFFFFFFC;
    }

    public static int alignPot(int size, int to) {
        return size + (to - 1) & ~(to - 1);
    }

    public static int ceilingDiv(int numerator, int denominator) {
        return (numerator + denominator - 1) / denominator;
    }

    public static long ceilingDiv(long numerator, long denominator) {
        return (numerator + denominator - 1L) / denominator;
    }

    public static long ceilLong(double d) {
        return (long)Math.ceil(d);
    }

    public static long ceilLong(float f) {
        return (long)Math.ceil(f);
    }
}

