/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl.visualization.storage;

import dev.engine_room.flywheel.api.visual.BlockEntityVisual;
import dev.engine_room.flywheel.api.visualization.BlockEntityVisualizer;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.impl.visualization.storage.Storage;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class BlockEntityStorage
extends Storage<BlockEntity> {
    private final Long2ObjectMap<BlockEntityVisual<?>> posLookup = new Long2ObjectOpenHashMap();

    @Nullable
    public BlockEntityVisual<?> visualAtPos(long pos) {
        return (BlockEntityVisual)this.posLookup.get(pos);
    }

    @Override
    public boolean willAccept(BlockEntity blockEntity) {
        if (blockEntity.m_58901_()) {
            return false;
        }
        if (!VisualizationHelper.canVisualize(blockEntity)) {
            return false;
        }
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return false;
        }
        if (level.m_46859_(blockEntity.m_58899_())) {
            return false;
        }
        BlockPos pos = blockEntity.m_58899_();
        BlockGetter existingChunk = level.m_7925_(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        return existingChunk != null;
    }

    @Nullable
    protected BlockEntityVisual<?> createRaw(VisualizationContext visualizationContext, BlockEntity obj, float partialTick) {
        BlockEntityVisualizer<BlockEntity> visualizer = VisualizationHelper.getVisualizer(obj);
        if (visualizer == null) {
            return null;
        }
        BlockEntityVisual<BlockEntity> visual = visualizer.createVisual(visualizationContext, obj, partialTick);
        BlockPos blockPos = obj.m_58899_();
        this.posLookup.put(blockPos.m_121878_(), visual);
        return visual;
    }

    @Override
    public void remove(BlockEntity obj) {
        this.posLookup.remove(obj.m_58899_().m_121878_());
        super.remove(obj);
    }

    @Override
    public void recreateAll(VisualizationContext visualizationContext, float partialTick) {
        this.posLookup.clear();
        super.recreateAll(visualizationContext, partialTick);
    }

    @Override
    public void invalidate() {
        this.posLookup.clear();
        super.invalidate();
    }
}

