/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl;

import dev.engine_room.flywheel.backend.compile.FlwProgramsReloader;
import dev.engine_room.flywheel.backend.engine.uniform.Uniforms;
import dev.engine_room.flywheel.impl.BackendArgument;
import dev.engine_room.flywheel.impl.BackendManagerImpl;
import dev.engine_room.flywheel.impl.DebugModeArgument;
import dev.engine_room.flywheel.impl.FlwCommands;
import dev.engine_room.flywheel.impl.FlwDebugInfo;
import dev.engine_room.flywheel.impl.FlwImpl;
import dev.engine_room.flywheel.impl.ForgeFlwConfig;
import dev.engine_room.flywheel.impl.LightSmoothnessArgument;
import dev.engine_room.flywheel.impl.compat.EmbeddiumCompat;
import dev.engine_room.flywheel.impl.visualization.VisualizationEventHandler;
import dev.engine_room.flywheel.lib.model.baked.PartialModelEventHandler;
import dev.engine_room.flywheel.lib.util.LevelAttached;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import dev.engine_room.flywheel.lib.util.ResourceReloadHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.CrashReportCallables;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.annotations.UnknownNullability;

@Mod(value="flywheel")
public final class FlywheelForge {
    private static @UnknownNullability ArtifactVersion version;

    public FlywheelForge() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        version = modLoadingContext.getActiveContainer().getModInfo().getVersion();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeFlwConfig.INSTANCE.registerSpecs(modLoadingContext);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FlywheelForge.clientInit(forgeEventBus, modEventBus));
    }

    private static void clientInit(IEventBus forgeEventBus, IEventBus modEventBus) {
        FlywheelForge.registerImplEventListeners(forgeEventBus, modEventBus);
        FlywheelForge.registerLibEventListeners(forgeEventBus, modEventBus);
        FlywheelForge.registerBackendEventListeners(forgeEventBus, modEventBus);
        CrashReportCallables.registerCrashCallable((String)"Flywheel Backend", BackendManagerImpl::getBackendString);
        FlwImpl.init();
        EmbeddiumCompat.init();
    }

    private static void registerImplEventListeners(IEventBus forgeEventBus, IEventBus modEventBus) {
        forgeEventBus.addListener(e -> BackendManagerImpl.onReloadLevelRenderer(e.level()));
        forgeEventBus.addListener(e -> {
            if (e.phase == TickEvent.Phase.END && e.side == LogicalSide.CLIENT) {
                VisualizationEventHandler.onClientTick(Minecraft.m_91087_(), e.level);
            }
        });
        forgeEventBus.addListener(e -> VisualizationEventHandler.onEntityJoinLevel(e.getLevel(), e.getEntity()));
        forgeEventBus.addListener(e -> VisualizationEventHandler.onEntityLeaveLevel(e.getLevel(), e.getEntity()));
        forgeEventBus.addListener(FlwCommands::registerClientCommands);
        forgeEventBus.addListener(e -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (!minecraft.f_91066_.f_92063_) {
                return;
            }
            FlwDebugInfo.addDebugInfo(minecraft, e.getRight());
        });
        modEventBus.addListener(e -> BackendManagerImpl.onEndClientResourceReload(e.error().isPresent()));
        modEventBus.addListener(e -> {
            ArgumentTypeInfos.registerByClass(BackendArgument.class, BackendArgument.INFO);
            ArgumentTypeInfos.registerByClass(DebugModeArgument.class, DebugModeArgument.INFO);
            ArgumentTypeInfos.registerByClass(LightSmoothnessArgument.class, LightSmoothnessArgument.INFO);
        });
    }

    private static void registerLibEventListeners(IEventBus forgeEventBus, IEventBus modEventBus) {
        forgeEventBus.addListener(e -> LevelAttached.invalidateLevel(e.getLevel()));
        modEventBus.addListener(e -> RendererReloadCache.onReloadLevelRenderer());
        modEventBus.addListener(e -> ResourceReloadHolder.onEndClientResourceReload());
        modEventBus.addListener(PartialModelEventHandler::onRegisterAdditional);
        modEventBus.addListener(PartialModelEventHandler::onBakingCompleted);
    }

    private static void registerBackendEventListeners(IEventBus forgeEventBus, IEventBus modEventBus) {
        forgeEventBus.addListener(e -> Uniforms.onReloadLevelRenderer());
        modEventBus.addListener(e -> e.registerReloadListener((PreparableReloadListener)FlwProgramsReloader.INSTANCE));
    }

    public static ArtifactVersion version() {
        return version;
    }
}

