/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.engine_room.flywheel.api.backend.Backend;
import dev.engine_room.flywheel.api.backend.BackendManager;
import dev.engine_room.flywheel.backend.BackendDebugFlags;
import dev.engine_room.flywheel.backend.compile.LightSmoothness;
import dev.engine_room.flywheel.backend.compile.PipelineCompiler;
import dev.engine_room.flywheel.backend.engine.uniform.DebugMode;
import dev.engine_room.flywheel.backend.engine.uniform.FrameUniforms;
import dev.engine_room.flywheel.impl.BackendArgument;
import dev.engine_room.flywheel.impl.DebugModeArgument;
import dev.engine_room.flywheel.impl.ForgeFlwConfig;
import dev.engine_room.flywheel.impl.ImplDebugFlags;
import dev.engine_room.flywheel.impl.LightSmoothnessArgument;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.ForgeConfigSpec;

public final class FlwCommands {
    private FlwCommands() {
    }

    public static void registerClientCommands(RegisterClientCommandsEvent event) {
        LiteralArgumentBuilder command = Commands.m_82127_((String)"flywheel");
        ForgeConfigSpec.ConfigValue<String> backendValue = ForgeFlwConfig.INSTANCE.client.backend;
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"backend").executes(context -> {
            Backend backend = BackendManager.currentBackend();
            String idStr = Backend.REGISTRY.getIdOrThrow(backend).toString();
            FlwCommands.sendMessage((CommandSourceStack)context.getSource(), (Component)Component.m_237110_((String)"command.flywheel.backend.get", (Object[])new Object[]{idStr}));
            return 1;
        })).then(Commands.m_82127_((String)"DEFAULT").executes(context -> {
            backendValue.set((Object)"DEFAULT");
            Minecraft.m_91087_().f_91060_.m_109818_();
            Backend actualBackend = BackendManager.currentBackend();
            String actualIdStr = Backend.REGISTRY.getIdOrThrow(actualBackend).toString();
            FlwCommands.sendMessage((CommandSourceStack)context.getSource(), (Component)Component.m_237110_((String)"command.flywheel.backend.set", (Object[])new Object[]{actualIdStr}));
            return 1;
        }))).then(Commands.m_82129_((String)"id", (ArgumentType)BackendArgument.INSTANCE).executes(context -> {
            Backend requestedBackend = (Backend)context.getArgument("id", Backend.class);
            String requestedIdStr = Backend.REGISTRY.getIdOrThrow(requestedBackend).toString();
            backendValue.set((Object)requestedIdStr);
            Minecraft.m_91087_().f_91060_.m_109818_();
            Backend actualBackend = BackendManager.currentBackend();
            if (actualBackend != requestedBackend) {
                FlwCommands.sendFailure((CommandSourceStack)context.getSource(), (Component)Component.m_237110_((String)"command.flywheel.backend.set.unavailable", (Object[])new Object[]{requestedIdStr}));
            }
            String actualIdStr = Backend.REGISTRY.getIdOrThrow(actualBackend).toString();
            FlwCommands.sendMessage((CommandSourceStack)context.getSource(), (Component)Component.m_237110_((String)"command.flywheel.backend.set", (Object[])new Object[]{actualIdStr}));
            return 1;
        })));
        ForgeConfigSpec.BooleanValue limitUpdatesValue = ForgeFlwConfig.INSTANCE.client.limitUpdates;
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"limitUpdates").executes(context -> {
            if (((Boolean)limitUpdatesValue.get()).booleanValue()) {
                FlwCommands.sendMessage((CommandSourceStack)context.getSource(), (Component)Component.m_237115_((String)"command.flywheel.limit_updates.get.on"));
            } else {
                FlwCommands.sendMessage((CommandSourceStack)context.getSource(), (Component)Component.m_237115_((String)"command.flywheel.limit_updates.get.off"));
            }
            return 1;
        })).then(Commands.m_82127_((String)"on").executes(context -> {
            limitUpdatesValue.set((Object)true);
            FlwCommands.sendMessage((CommandSourceStack)context.getSource(), (Component)Component.m_237115_((String)"command.flywheel.limit_updates.set.on"));
            Minecraft.m_91087_().f_91060_.m_109818_();
            return 1;
        }))).then(Commands.m_82127_((String)"off").executes(context -> {
            limitUpdatesValue.set((Object)false);
            FlwCommands.sendMessage((CommandSourceStack)context.getSource(), (Component)Component.m_237115_((String)"command.flywheel.limit_updates.set.off"));
            Minecraft.m_91087_().f_91060_.m_109818_();
            return 1;
        })));
        ForgeConfigSpec.EnumValue<LightSmoothness> lightSmoothnessValue = ForgeFlwConfig.INSTANCE.client.backendConfig.lightSmoothness;
        command.then(Commands.m_82127_((String)"lightSmoothness").then(Commands.m_82129_((String)"mode", (ArgumentType)LightSmoothnessArgument.INSTANCE).executes(context -> {
            LightSmoothness newValue;
            LightSmoothness oldValue = (LightSmoothness)((Object)((Object)lightSmoothnessValue.get()));
            if (oldValue != (newValue = (LightSmoothness)((Object)((Object)context.getArgument("mode", LightSmoothness.class))))) {
                lightSmoothnessValue.set((Object)newValue);
                PipelineCompiler.deleteAll();
            }
            return 1;
        })));
        command.then(FlwCommands.createDebugCommand());
        event.getDispatcher().register(command);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createDebugCommand() {
        LiteralArgumentBuilder debug = Commands.m_82127_((String)"debug");
        debug.then(Commands.m_82127_((String)"crumbling").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"stage", (ArgumentType)IntegerArgumentType.integer((int)0, (int)9)).executes(context -> {
            Entity executor = ((CommandSourceStack)context.getSource()).m_81373_();
            if (executor == null) {
                return 0;
            }
            BlockPos pos = BlockPosArgument.m_264582_((CommandContext)context, (String)"pos");
            int value = IntegerArgumentType.getInteger((CommandContext)context, (String)"stage");
            executor.m_9236_().m_6801_(executor.m_19879_(), pos, value);
            return 1;
        }))));
        debug.then(Commands.m_82127_((String)"shader").then(Commands.m_82129_((String)"mode", (ArgumentType)DebugModeArgument.INSTANCE).executes(context -> {
            DebugMode mode = (DebugMode)((Object)((Object)context.getArgument("mode", DebugMode.class)));
            FrameUniforms.debugMode(mode);
            return 1;
        })));
        debug.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"frustum").then(Commands.m_82127_((String)"capture").executes(context -> {
            FrameUniforms.captureFrustum();
            return 1;
        }))).then(Commands.m_82127_((String)"unpause").executes(context -> {
            FrameUniforms.unpauseFrustum();
            return 1;
        })));
        debug.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"lightSections").then(Commands.m_82127_((String)"on").executes(context -> {
            BackendDebugFlags.LIGHT_STORAGE_VIEW = true;
            return 1;
        }))).then(Commands.m_82127_((String)"off").executes(context -> {
            BackendDebugFlags.LIGHT_STORAGE_VIEW = false;
            return 1;
        })));
        debug.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"pauseUpdates").then(Commands.m_82127_((String)"on").executes(context -> {
            ImplDebugFlags.PAUSE_UPDATES = true;
            return 1;
        }))).then(Commands.m_82127_((String)"off").executes(context -> {
            ImplDebugFlags.PAUSE_UPDATES = false;
            return 1;
        })));
        return debug;
    }

    private static void sendMessage(CommandSourceStack source, Component message) {
        source.m_288197_(() -> message, true);
    }

    private static void sendFailure(CommandSourceStack source, Component message) {
        source.m_81352_(message);
    }
}

