/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.glsl.generate;

import dev.engine_room.flywheel.backend.glsl.generate.GlslFn;
import dev.engine_room.flywheel.backend.glsl.generate.GlslStruct;
import dev.engine_room.flywheel.backend.glsl.generate.GlslUniform;
import dev.engine_room.flywheel.backend.glsl.generate.GlslUniformBlock;
import dev.engine_room.flywheel.backend.glsl.generate.GlslVertexInput;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GlslBuilder {
    private final List<Declaration> elements = new ArrayList<Declaration>();

    public void define(String name, String value) {
        this.add(new Define(name, value));
    }

    public void undef(String key) {
        this.add(new Undef(key));
    }

    public GlslStruct struct() {
        return this.add(new GlslStruct());
    }

    public GlslVertexInput vertexInput() {
        return this.add(new GlslVertexInput());
    }

    public GlslUniform uniform() {
        return this.add(new GlslUniform());
    }

    public GlslUniformBlock uniformBlock() {
        return this.add(new GlslUniformBlock());
    }

    public GlslFn function() {
        return this.add(new GlslFn());
    }

    public void blankLine() {
        this.add(Separators.BLANK_LINE);
    }

    public void _raw(String sourceString) {
        this.add(new Raw(sourceString));
    }

    public <T extends Declaration> T add(T element) {
        this.elements.add(element);
        return element;
    }

    public String build() {
        return this.elements.stream().map(Declaration::prettyPrint).collect(Collectors.joining("\n"));
    }

    public record Define(String name, String value) implements Declaration
    {
        @Override
        public String prettyPrint() {
            return "#define " + this.name + " " + this.value;
        }
    }

    public static interface Declaration {
        public String prettyPrint();
    }

    public record Undef(String name) implements Declaration
    {
        @Override
        public String prettyPrint() {
            return "#undef " + this.name;
        }
    }

    public static enum Separators implements Declaration
    {
        BLANK_LINE("");

        private final String separator;

        private Separators(String separator) {
            this.separator = separator;
        }

        @Override
        public String prettyPrint() {
            return this.separator;
        }
    }

    public record Raw(String sourceString) implements Declaration
    {
        @Override
        public String prettyPrint() {
            return this.sourceString;
        }
    }
}

