/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.engine.uniform;

import dev.engine_room.flywheel.lib.util.ExtraMemoryOps;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryUtil;

class UniformWriter {
    UniformWriter() {
    }

    static long writeInt(long ptr, int value) {
        MemoryUtil.memPutInt((long)ptr, (int)value);
        return ptr + 4L;
    }

    static long writeFloat(long ptr, float value) {
        MemoryUtil.memPutFloat((long)ptr, (float)value);
        return ptr + 4L;
    }

    static long writeVec2(long ptr, float x, float y) {
        MemoryUtil.memPutFloat((long)ptr, (float)x);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)y);
        return ptr + 8L;
    }

    static long writeVec3(long ptr, float x, float y, float z) {
        MemoryUtil.memPutFloat((long)ptr, (float)x);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)z);
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)0.0f);
        return ptr + 16L;
    }

    static long writeVec3(long ptr, Vector3fc vec) {
        return UniformWriter.writeVec3(ptr, vec.x(), vec.y(), vec.z());
    }

    static long writeVec4(long ptr, float x, float y, float z, float w) {
        MemoryUtil.memPutFloat((long)ptr, (float)x);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)z);
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)w);
        return ptr + 16L;
    }

    static long writeIVec2(long ptr, int x, int y) {
        MemoryUtil.memPutInt((long)ptr, (int)x);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)y);
        return ptr + 8L;
    }

    static long writeIVec3(long ptr, int x, int y, int z) {
        MemoryUtil.memPutInt((long)ptr, (int)x);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)y);
        MemoryUtil.memPutInt((long)(ptr + 8L), (int)z);
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)0);
        return ptr + 16L;
    }

    static long writeIVec4(long ptr, int x, int y, int z, int w) {
        MemoryUtil.memPutInt((long)ptr, (int)x);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)y);
        MemoryUtil.memPutInt((long)(ptr + 8L), (int)z);
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)w);
        return ptr + 16L;
    }

    static long writeMat4(long ptr, Matrix4f mat) {
        ExtraMemoryOps.putMatrix4f(ptr, (Matrix4fc)mat);
        return ptr + 64L;
    }

    static long writeInFluidAndBlock(long ptr, Level level, BlockPos blockPos, Vec3 pos) {
        FluidState fluidState = level.m_6425_(blockPos);
        BlockState blockState = level.m_8055_(blockPos);
        float height = fluidState.m_76155_((BlockGetter)level, blockPos);
        if (fluidState.m_76178_()) {
            MemoryUtil.memPutInt((long)ptr, (int)0);
        } else if (pos.f_82480_ < (double)((float)blockPos.m_123342_() + height)) {
            if (fluidState.m_205070_(FluidTags.f_13131_)) {
                MemoryUtil.memPutInt((long)ptr, (int)1);
            } else if (fluidState.m_205070_(FluidTags.f_13132_)) {
                MemoryUtil.memPutInt((long)ptr, (int)2);
            } else {
                MemoryUtil.memPutInt((long)ptr, (int)-1);
            }
        }
        if (blockState.m_60795_()) {
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)0);
        } else if (blockState.m_60713_(Blocks.f_152499_)) {
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)0);
        } else {
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)-1);
        }
        return ptr + 8L;
    }
}

