/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.engine.indirect;

import dev.engine_room.flywheel.backend.compile.IndirectPrograms;
import dev.engine_room.flywheel.backend.engine.indirect.ScatterList;
import dev.engine_room.flywheel.backend.engine.indirect.TransferList;
import dev.engine_room.flywheel.backend.gl.GlFence;
import dev.engine_room.flywheel.backend.gl.buffer.GlBuffer;
import dev.engine_room.flywheel.backend.gl.buffer.GlBufferUsage;
import dev.engine_room.flywheel.lib.memory.FlwMemoryTracker;
import dev.engine_room.flywheel.lib.memory.MemoryBlock;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL45;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.system.MemoryUtil;

public class StagingBuffer {
    private static final long DEFAULT_CAPACITY = 0x1000000L;
    private static final int STORAGE_FLAGS = 578;
    private static final int MAP_FLAGS = 90;
    private static final int SSBO_ALIGNMENT = GL45.glGetInteger((int)37087);
    private final int vbo;
    private final long map;
    private final long capacity;
    private final IndirectPrograms programs;
    private final OverflowStagingBuffer overflow = new OverflowStagingBuffer();
    private final TransferList transfers = new TransferList();
    private final PriorityQueue<FencedRegion> fencedRegions = new ObjectArrayFIFOQueue();
    private final GlBuffer scatterBuffer = new GlBuffer(GlBufferUsage.STREAM_COPY);
    private final ScatterList scatterList = new ScatterList();
    private long start = 0L;
    private long pos = 0L;
    private long usedCapacity = 0L;
    private long totalAvailable;
    @Nullable
    private MemoryBlock scratch;

    public StagingBuffer(IndirectPrograms programs) {
        this(0x1000000L, programs);
    }

    public StagingBuffer(long capacity, IndirectPrograms programs) {
        this.capacity = capacity;
        this.programs = programs;
        this.vbo = GL45C.glCreateBuffers();
        GL45C.glNamedBufferStorage((int)this.vbo, (long)capacity, (int)578);
        this.map = GL45C.nglMapNamedBufferRange((int)this.vbo, (long)0L, (long)capacity, (int)90);
        this.totalAvailable = capacity;
        FlwMemoryTracker._allocCpuMemory(capacity);
    }

    public void enqueueCopy(long size, int dstVbo, long dstOffset, LongConsumer write) {
        long direct = this.reserveForCopy(size, dstVbo, dstOffset);
        if (direct != 0L) {
            write.accept(direct);
            return;
        }
        MemoryBlock block = this.getScratch(size);
        write.accept(block.ptr());
        this.enqueueCopy(block.ptr(), size, dstVbo, dstOffset);
    }

    public void enqueueCopy(long ptr, long size, int dstVbo, long dstOffset) {
        this.assertMultipleOf4(size);
        if (size > this.totalAvailable) {
            this.overflow.upload(ptr, size, dstVbo, dstOffset);
            return;
        }
        long remaining = this.capacity - this.pos;
        if (size > remaining) {
            long split = size - remaining;
            MemoryUtil.memCopy((long)ptr, (long)(this.map + this.pos), (long)remaining);
            this.pushTransfer(dstVbo, this.pos, dstOffset, remaining);
            MemoryUtil.memCopy((long)(ptr + remaining), (long)this.map, (long)split);
            this.pushTransfer(dstVbo, 0L, dstOffset + remaining, split);
            this.pos = split;
        } else {
            MemoryUtil.memCopy((long)ptr, (long)(this.map + this.pos), (long)size);
            this.pushTransfer(dstVbo, this.pos, dstOffset, size);
            this.pos += size;
        }
    }

    public long reserveForCopy(long size, int dstVbo, long dstOffset) {
        this.assertMultipleOf4(size);
        long remaining = this.capacity - this.pos;
        if (size > remaining || size > this.totalAvailable) {
            return 0L;
        }
        long out = this.map + this.pos;
        this.pushTransfer(dstVbo, this.pos, dstOffset, size);
        this.pos += size;
        return out;
    }

    public void flush() {
        if (this.transfers.isEmpty()) {
            return;
        }
        this.flushUsedRegion();
        this.dispatchComputeCopies();
        this.transfers.reset();
        this.fencedRegions.enqueue((Object)new FencedRegion(new GlFence(), this.usedCapacity));
        this.usedCapacity = 0L;
        this.start = this.pos;
    }

    public void reclaim() {
        while (!this.fencedRegions.isEmpty()) {
            FencedRegion region = (FencedRegion)this.fencedRegions.first();
            if (!region.fence.isSignaled()) break;
            this.fencedRegions.dequeue();
            region.fence.delete();
            this.totalAvailable += region.capacity;
        }
    }

    public void delete() {
        GL45C.glUnmapNamedBuffer((int)this.vbo);
        GL45C.glDeleteBuffers((int)this.vbo);
        this.overflow.delete();
        this.scatterBuffer.delete();
        if (this.scratch != null) {
            this.scratch.free();
        }
        this.transfers.delete();
        this.scatterList.delete();
        FlwMemoryTracker._freeCpuMemory(this.capacity);
    }

    public MemoryBlock getScratch(long size) {
        if (this.scratch == null) {
            this.scratch = MemoryBlock.malloc(size);
        } else if (this.scratch.size() < size) {
            this.scratch = this.scratch.realloc(size);
        }
        return this.scratch;
    }

    private void pushTransfer(int dstVbo, long srcOffset, long dstOffset, long size) {
        if (this.totalAvailable < size) {
            throw new IllegalStateException("Not enough available space to transfer");
        }
        this.transfers.push(dstVbo, srcOffset, dstOffset, size);
        this.usedCapacity += size;
        this.totalAvailable -= size;
    }

    private void dispatchComputeCopies() {
        this.programs.getScatterProgram().bind();
        GL45.glBindBufferBase((int)37074, (int)1, (int)this.vbo);
        int transferCount = this.transfers.length();
        for (int i = 0; i < transferCount; ++i) {
            int nextVbo;
            int dstVbo = this.transfers.vbo(i);
            this.scatterList.pushTransfer(this.transfers, i);
            int n = nextVbo = i == transferCount - 1 ? -1 : this.transfers.vbo(i + 1);
            if (dstVbo == nextVbo) continue;
            this.dispatchScatter(dstVbo);
        }
    }

    private void dispatchScatter(int dstVbo) {
        long alignedPos;
        long remaining;
        long scatterSize = this.scatterList.usedBytes();
        if (scatterSize <= (remaining = this.capacity - (alignedPos = this.pos + (long)SSBO_ALIGNMENT - 1L - (this.pos + (long)SSBO_ALIGNMENT - 1L) % (long)SSBO_ALIGNMENT)) && scatterSize <= this.totalAvailable) {
            MemoryUtil.memCopy((long)this.scatterList.ptr(), (long)(this.map + alignedPos), (long)scatterSize);
            GL45.glBindBufferRange((int)37074, (int)0, (int)this.vbo, (long)alignedPos, (long)scatterSize);
            long alignmentCost = alignedPos - this.pos;
            this.usedCapacity += scatterSize + alignmentCost;
            this.totalAvailable -= scatterSize + alignmentCost;
            this.pos += scatterSize + alignmentCost;
        } else {
            this.scatterBuffer.upload(this.scatterList.ptr(), scatterSize);
            GL45.glBindBufferBase((int)37074, (int)0, (int)this.scatterBuffer.handle());
        }
        GL45.glBindBufferBase((int)37074, (int)2, (int)dstVbo);
        GL45.glDispatchCompute((int)this.scatterList.copyCount(), (int)1, (int)1);
        this.scatterList.reset();
    }

    private void assertMultipleOf4(long size) {
        if (size % 4L != 0L) {
            throw new IllegalArgumentException("Size must be a multiple of 4");
        }
    }

    private long sendCopyCommands() {
        long usedCapacity = 0L;
        for (int i = 0; i < this.transfers.length(); ++i) {
            long size = this.transfers.size(i);
            usedCapacity += size;
            GL45C.glCopyNamedBufferSubData((int)this.vbo, (int)this.transfers.vbo(i), (long)this.transfers.srcOffset(i), (long)this.transfers.dstOffset(i), (long)size);
        }
        return usedCapacity;
    }

    private void flushUsedRegion() {
        if (this.pos < this.start) {
            GL45C.glFlushMappedNamedBufferRange((int)this.vbo, (long)this.start, (long)(this.capacity - this.start));
            GL45C.glFlushMappedNamedBufferRange((int)this.vbo, (long)0L, (long)this.pos);
        } else {
            GL45C.glFlushMappedNamedBufferRange((int)this.vbo, (long)this.start, (long)(this.pos - this.start));
        }
    }

    private static class OverflowStagingBuffer {
        private final int vbo = GL45C.glCreateBuffers();

        public void upload(long ptr, long size, int dstVbo, long dstOffset) {
            GL45C.nglNamedBufferData((int)this.vbo, (long)size, (long)ptr, (int)35042);
            GL45C.glCopyNamedBufferSubData((int)this.vbo, (int)dstVbo, (long)0L, (long)dstOffset, (long)size);
        }

        public void delete() {
            GL45C.glDeleteBuffers((int)this.vbo);
        }
    }

    private record FencedRegion(GlFence fence, long capacity) {
    }
}

