/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.engine;

import dev.engine_room.flywheel.api.task.Plan;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.Effect;
import dev.engine_room.flywheel.api.visual.EffectVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.backend.BackendDebugFlags;
import dev.engine_room.flywheel.backend.SkyLightSectionStorageExtension;
import dev.engine_room.flywheel.backend.engine.CpuArena;
import dev.engine_room.flywheel.backend.engine.LightLut;
import dev.engine_room.flywheel.backend.engine.indirect.StagingBuffer;
import dev.engine_room.flywheel.backend.gl.buffer.GlBuffer;
import dev.engine_room.flywheel.backend.mixin.light.LightEngineAccessor;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.math.MoreMath;
import dev.engine_room.flywheel.lib.task.SimplePlan;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.component.HitboxComponent;
import dev.engine_room.flywheel.lib.visual.util.InstanceRecycler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.BitSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public class LightStorage
implements Effect {
    public static final int BLOCKS_PER_SECTION = 5832;
    public static final int LIGHT_SIZE_BYTES = 5832;
    public static final int SOLID_SIZE_BYTES = MoreMath.ceilingDiv(5832, 32) * 4;
    public static final int SECTION_SIZE_BYTES = SOLID_SIZE_BYTES + 5832;
    private static final int DEFAULT_ARENA_CAPACITY_SECTIONS = 64;
    private static final int INVALID_SECTION = -1;
    private static final ConstantDataLayer ALWAYS_0 = new ConstantDataLayer(0);
    private static final ConstantDataLayer ALWAYS_15 = new ConstantDataLayer(15);
    private final LevelAccessor level;
    private final LightLut lut;
    private final CpuArena arena;
    private final Long2IntMap section2ArenaIndex;
    private final BitSet changed = new BitSet();
    private boolean needsLutRebuild = false;
    private boolean isDebugOn = false;
    private final LongSet updatedSections = new LongOpenHashSet();
    @Nullable
    private LongSet requestedSections;

    public LightStorage(LevelAccessor level) {
        this.level = level;
        this.lut = new LightLut();
        this.arena = new CpuArena(SECTION_SIZE_BYTES, 64);
        this.section2ArenaIndex = new Long2IntOpenHashMap();
        this.section2ArenaIndex.defaultReturnValue(-1);
    }

    @Override
    public LevelAccessor level() {
        return this.level;
    }

    @Override
    public EffectVisual<?> visualize(VisualizationContext ctx, float partialTick) {
        return new DebugVisual(ctx, partialTick);
    }

    public void sections(LongSet sections) {
        this.requestedSections = sections;
    }

    public void onLightUpdate(long section) {
        this.updatedSections.add(section);
    }

    public <C> Plan<C> createFramePlan() {
        return SimplePlan.of(() -> {
            LongOpenHashSet sectionsToCollect;
            if (BackendDebugFlags.LIGHT_STORAGE_VIEW != this.isDebugOn) {
                VisualizationManager visualizationManager = VisualizationManager.get(this.level);
                if (visualizationManager != null) {
                    if (BackendDebugFlags.LIGHT_STORAGE_VIEW) {
                        visualizationManager.effects().queueAdd(this);
                    } else {
                        visualizationManager.effects().queueRemove(this);
                    }
                }
                this.isDebugOn = BackendDebugFlags.LIGHT_STORAGE_VIEW;
            }
            if (this.updatedSections.isEmpty() && this.requestedSections == null) {
                return;
            }
            this.removeUnusedSections();
            if (this.requestedSections == null) {
                sectionsToCollect = new LongOpenHashSet();
            } else {
                sectionsToCollect = new LongOpenHashSet((LongCollection)this.requestedSections);
                sectionsToCollect.removeAll((LongCollection)this.section2ArenaIndex.keySet());
            }
            LongIterator longIterator = this.updatedSections.iterator();
            while (longIterator.hasNext()) {
                long updatedSection = (Long)longIterator.next();
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            long section = SectionPos.m_123186_((long)updatedSection, (int)x, (int)y, (int)z);
                            if (!this.section2ArenaIndex.containsKey(section)) continue;
                            sectionsToCollect.add(section);
                        }
                    }
                }
            }
            sectionsToCollect.forEach(this::collectSection);
            this.updatedSections.clear();
            this.requestedSections = null;
        });
    }

    private void removeUnusedSections() {
        if (this.requestedSections == null) {
            return;
        }
        boolean anyRemoved = false;
        ObjectSet entries = this.section2ArenaIndex.long2IntEntrySet();
        ObjectIterator it = entries.iterator();
        while (it.hasNext()) {
            Long2IntMap.Entry entry = (Long2IntMap.Entry)it.next();
            long section = entry.getLongKey();
            if (this.requestedSections.contains(section)) continue;
            this.arena.free(entry.getIntValue());
            this.endTrackingSection(section);
            it.remove();
            anyRemoved = true;
        }
        if (anyRemoved) {
            this.lut.prune();
            this.needsLutRebuild = true;
        }
    }

    private void beginTrackingSection(long section, int index) {
        this.lut.add(section, index);
        this.needsLutRebuild = true;
    }

    private void endTrackingSection(long section) {
        this.lut.remove(section);
        this.needsLutRebuild = true;
    }

    public int capacity() {
        return this.arena.capacity();
    }

    public void collectSection(long section) {
        int index = this.indexForSection(section);
        this.changed.set(index);
        long ptr = this.arena.indexToPointer(index);
        MemoryUtil.memSet((long)ptr, (int)0, (long)SECTION_SIZE_BYTES);
        this.collectSolidData(ptr, section);
        this.collectCenter(ptr, section);
        for (SectionEdge i : SectionEdge.values()) {
            this.collectYZPlane(ptr, SectionPos.m_123186_((long)section, (int)i.sectionOffset, (int)0, (int)0), i);
            this.collectXZPlane(ptr, SectionPos.m_123186_((long)section, (int)0, (int)i.sectionOffset, (int)0), i);
            this.collectXYPlane(ptr, SectionPos.m_123186_((long)section, (int)0, (int)0, (int)i.sectionOffset), i);
            for (SectionEdge j : SectionEdge.values()) {
                this.collectXStrip(ptr, SectionPos.m_123186_((long)section, (int)0, (int)i.sectionOffset, (int)j.sectionOffset), i, j);
                this.collectYStrip(ptr, SectionPos.m_123186_((long)section, (int)i.sectionOffset, (int)0, (int)j.sectionOffset), i, j);
                this.collectZStrip(ptr, SectionPos.m_123186_((long)section, (int)i.sectionOffset, (int)j.sectionOffset, (int)0), i, j);
            }
        }
        this.collectCorners(ptr, section);
    }

    private void collectSolidData(long ptr, long section) {
        long[] longArray;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        int xMin = SectionPos.m_123223_((int)SectionPos.m_123213_((long)section));
        int yMin = SectionPos.m_123223_((int)SectionPos.m_123225_((long)section));
        int zMin = SectionPos.m_123223_((int)SectionPos.m_123230_((long)section));
        BitSet bitSet = new BitSet(5832);
        int index = 0;
        for (int y = -1; y < 17; ++y) {
            for (int z = -1; z < 17; ++z) {
                for (int x = -1; x < 17; ++x) {
                    blockPos.m_122178_(xMin + x, yMin + y, zMin + z);
                    BlockState blockState = this.level.m_8055_((BlockPos)blockPos);
                    if (blockState.m_60815_() && blockState.m_60838_((BlockGetter)this.level, (BlockPos)blockPos)) {
                        bitSet.set(index);
                    }
                    ++index;
                }
            }
        }
        for (long l : longArray = bitSet.toLongArray()) {
            MemoryUtil.memPutLong((long)ptr, (long)l);
            ptr += 8L;
        }
    }

    private DataLayer getSkyData(long section) {
        LightEngineAccessor accessor;
        Object s;
        LayerLightEventListener layerListener = this.level.m_5518_().m_75814_(LightLayer.SKY);
        if (layerListener == LayerLightEventListener.DummyLightLayerEventListener.INSTANCE) {
            return ALWAYS_0;
        }
        if (layerListener instanceof LightEngineAccessor && (s = (accessor = (LightEngineAccessor)layerListener).flywheel$storage()) instanceof SkyLightSectionStorageExtension) {
            SkyLightSectionStorageExtension skyStorage = (SkyLightSectionStorageExtension)s;
            DataLayer out = skyStorage.flywheel$skyDataLayer(section);
            return Objects.requireNonNullElse(out, ALWAYS_15);
        }
        return ALWAYS_0;
    }

    private DataLayer getBlockData(long section) {
        LayerLightEventListener layerListener = this.level.m_5518_().m_75814_(LightLayer.BLOCK);
        if (layerListener == LayerLightEventListener.DummyLightLayerEventListener.INSTANCE) {
            return ALWAYS_0;
        }
        if (layerListener instanceof LightEngineAccessor) {
            LightEngineAccessor accessor = (LightEngineAccessor)layerListener;
            DataLayer out = accessor.flywheel$storage().m_75793_(section);
            return Objects.requireNonNullElse(out, ALWAYS_0);
        }
        return ALWAYS_0;
    }

    private void collectXStrip(long ptr, long section, SectionEdge y, SectionEdge z) {
        DataLayer blockData = this.getBlockData(section);
        DataLayer skyData = this.getSkyData(section);
        for (int x = 0; x < 16; ++x) {
            this.write(ptr, x, y.relative, z.relative, blockData.m_62560_(x, y.pos, z.pos), skyData.m_62560_(x, y.pos, z.pos));
        }
    }

    private void collectYStrip(long ptr, long section, SectionEdge x, SectionEdge z) {
        DataLayer blockData = this.getBlockData(section);
        DataLayer skyData = this.getSkyData(section);
        for (int y = 0; y < 16; ++y) {
            this.write(ptr, x.relative, y, z.relative, blockData.m_62560_(x.pos, y, z.pos), skyData.m_62560_(x.pos, y, z.pos));
        }
    }

    private void collectZStrip(long ptr, long section, SectionEdge x, SectionEdge y) {
        DataLayer blockData = this.getBlockData(section);
        DataLayer skyData = this.getSkyData(section);
        for (int z = 0; z < 16; ++z) {
            this.write(ptr, x.relative, y.relative, z, blockData.m_62560_(x.pos, y.pos, z), skyData.m_62560_(x.pos, y.pos, z));
        }
    }

    private void collectYZPlane(long ptr, long section, SectionEdge x) {
        DataLayer blockData = this.getBlockData(section);
        DataLayer skyData = this.getSkyData(section);
        for (int y = 0; y < 16; ++y) {
            for (int z = 0; z < 16; ++z) {
                this.write(ptr, x.relative, y, z, blockData.m_62560_(x.pos, y, z), skyData.m_62560_(x.pos, y, z));
            }
        }
    }

    private void collectXZPlane(long ptr, long section, SectionEdge y) {
        DataLayer blockData = this.getBlockData(section);
        DataLayer skyData = this.getSkyData(section);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                this.write(ptr, x, y.relative, z, blockData.m_62560_(x, y.pos, z), skyData.m_62560_(x, y.pos, z));
            }
        }
    }

    private void collectXYPlane(long ptr, long section, SectionEdge z) {
        DataLayer blockData = this.getBlockData(section);
        DataLayer skyData = this.getSkyData(section);
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                this.write(ptr, x, y, z.relative, blockData.m_62560_(x, y, z.pos), skyData.m_62560_(x, y, z.pos));
            }
        }
    }

    private void collectCenter(long ptr, long section) {
        DataLayer blockData = this.getBlockData(section);
        DataLayer skyData = this.getSkyData(section);
        for (int y = 0; y < 16; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    this.write(ptr, x, y, z, blockData.m_62560_(x, y, z), skyData.m_62560_(x, y, z));
                }
            }
        }
    }

    private void collectCorners(long ptr, long section) {
        LevelLightEngine lightEngine = this.level.m_5518_();
        LayerLightEventListener blockLight = lightEngine.m_75814_(LightLayer.BLOCK);
        LayerLightEventListener skyLight = lightEngine.m_75814_(LightLayer.SKY);
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        int xMin = SectionPos.m_123223_((int)SectionPos.m_123213_((long)section));
        int yMin = SectionPos.m_123223_((int)SectionPos.m_123225_((long)section));
        int zMin = SectionPos.m_123223_((int)SectionPos.m_123230_((long)section));
        for (SectionEdge x : SectionEdge.values()) {
            for (SectionEdge y : SectionEdge.values()) {
                for (SectionEdge z : SectionEdge.values()) {
                    blockPos.m_122178_(x.relative + xMin, y.relative + yMin, z.relative + zMin);
                    this.write(ptr, x.relative, y.relative, z.relative, blockLight.m_7768_((BlockPos)blockPos), skyLight.m_7768_((BlockPos)blockPos));
                }
            }
        }
    }

    private void write(long ptr, int x, int y, int z, int block, int sky) {
        int x1 = x + 1;
        int y1 = y + 1;
        int z1 = z + 1;
        int offset = x1 + z1 * 18 + y1 * 18 * 18;
        long packedByte = block & 0xF | (sky & 0xF) << 4;
        MemoryUtil.memPutByte((long)(ptr + (long)SOLID_SIZE_BYTES + (long)offset), (byte)((byte)packedByte));
    }

    private long ptrForSection(long section) {
        return this.arena.indexToPointer(this.indexForSection(section));
    }

    private int indexForSection(long section) {
        int out = this.section2ArenaIndex.get(section);
        if (out == -1) {
            out = this.arena.alloc();
            this.section2ArenaIndex.put(section, out);
            this.beginTrackingSection(section, out);
        }
        return out;
    }

    public void delete() {
        this.arena.delete();
    }

    public boolean checkNeedsLutRebuildAndClear() {
        boolean out = this.needsLutRebuild;
        this.needsLutRebuild = false;
        return out;
    }

    public void uploadChangedSections(StagingBuffer staging, int dstVbo) {
        int i = this.changed.nextSetBit(0);
        while (i >= 0) {
            staging.enqueueCopy(this.arena.indexToPointer(i), (long)SECTION_SIZE_BYTES, dstVbo, i * SECTION_SIZE_BYTES);
            i = this.changed.nextSetBit(i + 1);
        }
        this.changed.clear();
    }

    public void upload(GlBuffer buffer) {
        if (this.changed.isEmpty()) {
            return;
        }
        buffer.upload(this.arena.indexToPointer(0), this.arena.capacity() * SECTION_SIZE_BYTES);
        this.changed.clear();
    }

    public IntArrayList createLut() {
        return this.lut.flatten();
    }

    public class DebugVisual
    implements EffectVisual<LightStorage>,
    SimpleDynamicVisual {
        private final InstanceRecycler<TransformedInstance> boxes;
        private final Vec3i renderOrigin;

        public DebugVisual(VisualizationContext ctx, float partialTick) {
            this.renderOrigin = ctx.renderOrigin();
            this.boxes = new InstanceRecycler<TransformedInstance>(() -> ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, HitboxComponent.BOX_MODEL).createInstance());
        }

        @Override
        public void beginFrame(DynamicVisual.Context ctx) {
            this.boxes.resetCount();
            this.setupSectionBoxes();
            this.setupLutRangeBoxes();
            this.boxes.discardExtra();
        }

        private void setupSectionBoxes() {
            LightStorage.this.section2ArenaIndex.keySet().forEach(l -> {
                int x = SectionPos.m_123213_((long)l) * 16 - this.renderOrigin.m_123341_();
                int y = SectionPos.m_123225_((long)l) * 16 - this.renderOrigin.m_123342_();
                int z = SectionPos.m_123230_((long)l) * 16 - this.renderOrigin.m_123343_();
                TransformedInstance instance = this.boxes.get();
                ((TransformedInstance)instance.setIdentityTransform().translate(x, y, z).scale(16.0f)).color(255, 255, 0).light(0xF000F0).setChanged();
            });
        }

        private void setupLutRangeBoxes() {
            LightLut.Layer<LightLut.Layer<LightLut.IntLayer>> first = LightStorage.this.lut.indices;
            int base1 = first.base();
            int size1 = first.size();
            float debug1 = base1 * 16 - this.renderOrigin.m_123342_();
            float min2 = Float.POSITIVE_INFINITY;
            float max2 = Float.NEGATIVE_INFINITY;
            float min3 = Float.POSITIVE_INFINITY;
            float max3 = Float.NEGATIVE_INFINITY;
            for (int y = 0; y < size1; ++y) {
                LightLut.Layer<LightLut.IntLayer> second = first.getRaw(y);
                if (second == null) continue;
                int base2 = second.base();
                int size2 = second.size();
                float y2 = (float)((base1 + y) * 16 - this.renderOrigin.m_123342_()) + 7.5f;
                min2 = Math.min(min2, (float)base2);
                max2 = Math.max(max2, (float)(base2 + size2));
                float minLocal3 = Float.POSITIVE_INFINITY;
                float maxLocal3 = Float.NEGATIVE_INFINITY;
                float debug2 = base2 * 16 - this.renderOrigin.m_123341_();
                for (int x = 0; x < size2; ++x) {
                    LightLut.IntLayer third = second.getRaw(x);
                    if (third == null) continue;
                    int base3 = third.base();
                    int size3 = third.size();
                    float x2 = (float)((base2 + x) * 16 - this.renderOrigin.m_123341_()) + 7.5f;
                    min3 = Math.min(min3, (float)base3);
                    max3 = Math.max(max3, (float)(base3 + size3));
                    minLocal3 = Math.min(minLocal3, (float)base3);
                    maxLocal3 = Math.max(maxLocal3, (float)(base3 + size3));
                    float debug3 = base3 * 16 - this.renderOrigin.m_123343_();
                    for (int z = 0; z < size3; ++z) {
                        this.boxes.get().setIdentityTransform().translate(x2, y2, debug3).scale(1.0f, 1.0f, size3 * 16).color(0, 0, 255).light(0xF000F0).setChanged();
                    }
                }
                this.boxes.get().setIdentityTransform().translate(debug2, y2, minLocal3 * 16.0f - (float)this.renderOrigin.m_123343_()).scale(size2 * 16, 1.0f, (maxLocal3 - minLocal3) * 16.0f).color(255, 0, 0).light(0xF000F0).setChanged();
            }
            this.boxes.get().setIdentityTransform().translate(min2 * 16.0f - (float)this.renderOrigin.m_123341_(), debug1, min3 * 16.0f - (float)this.renderOrigin.m_123343_()).scale((max2 - min2) * 16.0f, size1 * 16, (max3 - min3) * 16.0f).color(0, 255, 0).light(0xF000F0).setChanged();
        }

        @Override
        public void update(float partialTick) {
        }

        @Override
        public void delete() {
            this.boxes.delete();
        }
    }

    private static enum SectionEdge {
        LOW(15, -1, -1),
        HIGH(0, 16, 1);

        private final int pos;
        private final int relative;
        private final int sectionOffset;

        private SectionEdge(int pos, int relative, int sectionOffset) {
            this.pos = pos;
            this.relative = relative;
            this.sectionOffset = sectionOffset;
        }
    }

    private static class ConstantDataLayer
    extends DataLayer {
        private final int value;

        private ConstantDataLayer(int value) {
            this.value = value;
        }

        public int m_62560_(int x, int y, int z) {
            return this.value;
        }
    }
}

