/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.compile.core;

import dev.engine_room.flywheel.backend.compile.core.ShaderException;
import dev.engine_room.flywheel.backend.gl.shader.GlProgram;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LinkResult {
    public GlProgram unwrap();

    public static LinkResult success(GlProgram program, String log) {
        return new Success(program, log);
    }

    public static LinkResult failure(String failure) {
        return new Failure(failure);
    }

    public record Success(GlProgram program, String log) implements LinkResult
    {
        @Override
        @NotNull
        public GlProgram unwrap() {
            return this.program;
        }
    }

    public record Failure(String failure) implements LinkResult
    {
        @Override
        public GlProgram unwrap() {
            throw new ShaderException.Link(this.failure);
        }
    }
}

