/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.compile;

import dev.engine_room.flywheel.api.layout.ArrayElementType;
import dev.engine_room.flywheel.api.layout.ElementType;
import dev.engine_room.flywheel.api.layout.FloatRepr;
import dev.engine_room.flywheel.api.layout.IntegerRepr;
import dev.engine_room.flywheel.api.layout.MatrixElementType;
import dev.engine_room.flywheel.api.layout.ScalarElementType;
import dev.engine_room.flywheel.api.layout.UnsignedIntegerRepr;
import dev.engine_room.flywheel.api.layout.ValueRepr;
import dev.engine_room.flywheel.api.layout.VectorElementType;

public class LayoutInterpreter {
    public static String typeName(ElementType type) {
        if (type instanceof ScalarElementType) {
            ScalarElementType scalar = (ScalarElementType)type;
            return LayoutInterpreter.scalarTypeName(scalar);
        }
        if (type instanceof VectorElementType) {
            VectorElementType vector = (VectorElementType)type;
            return LayoutInterpreter.vectorTypeName(vector);
        }
        if (type instanceof MatrixElementType) {
            MatrixElementType matrix = (MatrixElementType)type;
            return LayoutInterpreter.matrixTypeName(matrix);
        }
        if (type instanceof ArrayElementType) {
            ArrayElementType array = (ArrayElementType)type;
            return LayoutInterpreter.arrayTypeName(array);
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static String scalarTypeName(ScalarElementType scalar) {
        ValueRepr repr = scalar.repr();
        if (repr instanceof IntegerRepr) {
            return "int";
        }
        if (repr instanceof UnsignedIntegerRepr) {
            return "uint";
        }
        if (repr instanceof FloatRepr) {
            return "float";
        }
        throw new IllegalArgumentException("Unknown repr " + repr);
    }

    public static String vectorTypeName(VectorElementType vector) {
        ValueRepr repr = vector.repr();
        int size = vector.size();
        if (repr instanceof IntegerRepr) {
            return "ivec" + size;
        }
        if (repr instanceof UnsignedIntegerRepr) {
            return "uvec" + size;
        }
        if (repr instanceof FloatRepr) {
            return "vec" + size;
        }
        throw new IllegalArgumentException("Unknown repr " + repr);
    }

    public static String matrixTypeName(MatrixElementType matrix) {
        return "mat" + matrix.columns() + "x" + matrix.rows();
    }

    public static String arrayTypeName(ArrayElementType array) {
        return LayoutInterpreter.typeName(array.innerType()) + "[" + array.length() + "]";
    }
}

