/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.api.backend;

import dev.engine_room.flywheel.api.backend.BackendImplemented;
import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.task.Plan;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Range;

@BackendImplemented
public interface Engine {
    public VisualizationContext createVisualizationContext();

    public Plan<RenderContext> createFramePlan();

    public Vec3i renderOrigin();

    public boolean updateRenderOrigin(Camera var1);

    public void lightSections(LongSet var1);

    public void onLightUpdate(SectionPos var1, LightLayer var2);

    public void render(RenderContext var1);

    public void renderCrumbling(RenderContext var1, List<CrumblingBlock> var2);

    public void delete();

    @ApiStatus.NonExtendable
    public static interface CrumblingBlock {
        public BlockPos pos();

        public @Range(from=0L, to=9L) int progress();

        public List<Instance> instances();
    }
}

