/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils.ui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix4f;

public class CustomFramebuffer {
    private int fbo = -1;
    private int colorAttachment = -1;
    private int depthStencilAttachment = -1;
    private int width;
    private int height;

    public void setSize(int nWidth, int nHeight) {
        if (nWidth == 0 || nHeight == 0) {
            return;
        }
        if (nWidth != this.width || nHeight != this.height) {
            this.width = nWidth;
            this.height = nHeight;
            if (this.fbo != -1) {
                GlStateManager._glDeleteFramebuffers((int)this.fbo);
                this.fbo = -1;
            }
            if (this.colorAttachment != -1) {
                TextureUtil.releaseTextureId((int)this.colorAttachment);
                this.colorAttachment = -1;
            }
            if (this.depthStencilAttachment != -1) {
                TextureUtil.releaseTextureId((int)this.depthStencilAttachment);
                this.depthStencilAttachment = -1;
            }
            this.fbo = GlStateManager.glGenFramebuffers();
            this.colorAttachment = TextureUtil.generateTextureId();
            this.depthStencilAttachment = TextureUtil.generateTextureId();
            GlStateManager._bindTexture((int)this.depthStencilAttachment);
            GlStateManager._texImage2D((int)3553, (int)0, (int)35056, (int)this.width, (int)this.height, (int)0, (int)34041, (int)34042, null);
            GlStateManager._bindTexture((int)this.colorAttachment);
            GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, null);
            GlStateManager._glBindFramebuffer((int)36160, (int)this.fbo);
            GlStateManager._bindTexture((int)this.colorAttachment);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9729);
            GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
            GlStateManager._glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.colorAttachment, (int)0);
            GlStateManager._bindTexture((int)this.depthStencilAttachment);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9729);
            GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
            GlStateManager._glFramebufferTexture2D((int)36160, (int)33306, (int)3553, (int)this.depthStencilAttachment, (int)0);
        }
    }

    public int getFbo() {
        return this.fbo;
    }

    public void drawToScreen(int viewWidth, int viewHeight) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._disableDepthTest();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._viewport((int)0, (int)0, (int)viewWidth, (int)viewHeight);
        Minecraft minecraftClient = Minecraft.m_91087_();
        ShaderInstance shader = minecraftClient.f_91063_.f_172635_;
        shader.m_173350_("DiffuseSampler", (Object)this.colorAttachment);
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)viewWidth, (float)viewHeight, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276633_);
        if (shader.f_173308_ != null) {
            shader.f_173308_.m_5679_(new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
        }
        if (shader.f_173309_ != null) {
            shader.f_173309_.m_5679_(matrix4f);
        }
        shader.m_173363_();
        Tesselator tessellator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_5483_(0.0, (double)viewHeight, 0.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_((double)viewWidth, (double)viewHeight, 0.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_((double)viewWidth, 0.0, 0.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        shader.m_173362_();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }
}

