/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.IOUtils;
import org.lwjgl.BufferUtils;

public class FileTexture
extends DynamicTexture {
    private final ResourceLocation id;

    private FileTexture(NativeImage image, ResourceLocation id) {
        super(image);
        this.id = id;
        Minecraft.m_91087_().m_91097_().m_118495_(id, (AbstractTexture)this);
    }

    public static FileTexture of(Path path) throws IOException {
        String s = path.toString();
        FiguraIdentifier resourceLocation = new FiguraIdentifier("file/" + FiguraIdentifier.formatPath(s));
        return new FileTexture(FileTexture.readImage(path), resourceLocation);
    }

    public static NativeImage readImage(Path path) throws IOException {
        byte[] bytes = IOUtils.readFileBytes(path);
        ByteBuffer wrapper = BufferUtils.createByteBuffer((int)bytes.length);
        wrapper.put(bytes);
        wrapper.rewind();
        return NativeImage.m_85062_((ByteBuffer)wrapper);
    }

    public ResourceLocation getLocation() {
        return this.id;
    }
}

