/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.figuramc.figura.mixin.ClientLevelInvoker;
import org.figuramc.figura.mixin.EntityAccessor;
import org.figuramc.figura.mixin.gui.PlayerTabOverlayAccessor;

public class EntityUtils {
    public static Entity getEntityByUUID(UUID uuid) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return null;
        }
        return (Entity)((ClientLevelInvoker)Minecraft.m_91087_().f_91073_).getEntityGetter().m_142694_(uuid);
    }

    public static Entity getViewedEntity(float distance) {
        BlockHitResult blockResult;
        double raycastDistanceSquared;
        Entity entity = Minecraft.m_91087_().m_91288_();
        if (entity == null) {
            return null;
        }
        float tickDelta = Minecraft.m_91087_().m_91296_();
        Vec3 entityEye = entity.m_20299_(tickDelta);
        Vec3 viewVec = entity.m_20252_(tickDelta).m_82490_((double)distance);
        AABB box = entity.m_20191_().m_82369_(viewVec).m_82377_(1.0, 1.0, 1.0);
        Vec3 raycastEnd = entityEye.m_82549_(viewVec);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)entityEye, (Vec3)raycastEnd, (AABB)box, entity1 -> !entity1.m_5833_() && entity1.m_6087_(), (double)(raycastDistanceSquared = (blockResult = ((EntityAccessor)entity).getLevel().m_45547_(new ClipContext(entityEye, raycastEnd, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, entity))) != null ? blockResult.m_82450_().m_82557_(entityEye) : (double)(distance * distance)));
        if (entityHitResult != null) {
            return entityHitResult.m_82443_();
        }
        return null;
    }

    public static PlayerInfo getPlayerInfo(UUID uuid) {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        return connection == null ? null : connection.m_104949_(uuid);
    }

    public static String getNameForUUID(UUID uuid) {
        PlayerInfo player = EntityUtils.getPlayerInfo(uuid);
        if (player != null) {
            return player.m_105312_().getName();
        }
        Entity e = EntityUtils.getEntityByUUID(uuid);
        if (e != null) {
            return e.m_7755_().getString();
        }
        return null;
    }

    public static Map<String, UUID> getPlayerList() {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection == null || connection.m_105143_().isEmpty()) {
            return Map.of();
        }
        HashMap<String, UUID> playerList = new HashMap<String, UUID>();
        for (UUID uuid : connection.m_105143_()) {
            PlayerInfo player = connection.m_104949_(uuid);
            if (player == null) continue;
            playerList.put(player.m_105312_().getName(), uuid);
        }
        return playerList;
    }

    public static List<PlayerInfo> getTabList() {
        return ((PlayerTabOverlayAccessor)Minecraft.m_91087_().f_91065_.m_93088_()).getThePlayerInfos();
    }

    public static boolean checkInvalidPlayer(UUID id) {
        if (id.version() != 4) {
            return true;
        }
        PlayerInfo playerInfo = EntityUtils.getPlayerInfo(id);
        if (playerInfo == null) {
            return false;
        }
        GameProfile profile = playerInfo.m_105312_();
        String name = profile.getName();
        return name != null && (name.isBlank() || name.charAt(0) == '\u0000');
    }
}

