/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.parsers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.model.rendering.texture.RenderTypes;
import org.figuramc.figura.parsers.BlockbenchModelParser;
import org.figuramc.figura.utils.PathUtils;
import org.figuramc.figura.utils.Version;

public class AvatarMetadataParser {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<String, String> PARTS_TO_MOVE = new HashMap<String, String>();

    public static Metadata read(String json) {
        Metadata metadata = (Metadata)GSON.fromJson(json, Metadata.class);
        return metadata == null ? new Metadata() : metadata;
    }

    public static CompoundTag parse(String json, String filename) {
        Metadata metadata = AvatarMetadataParser.read(json);
        return AvatarMetadataParser.parse(metadata, json, filename);
    }

    public static CompoundTag parse(Metadata metadata, String json, String filename) {
        String name;
        int n;
        CompoundTag nbt = new CompoundTag();
        JsonElement jsonElement = JsonParser.parseString((String)json);
        if (jsonElement != null && !jsonElement.isJsonNull() && !jsonElement.getAsJsonObject().asMap().isEmpty()) {
            for (Map.Entry jsonElementEntry : jsonElement.getAsJsonObject().entrySet()) {
                if (jsonElementEntry.getKey() == null || ((String)jsonElementEntry.getKey()).isBlank() || !((String)jsonElementEntry.getKey()).contains("badge_color_")) continue;
                nbt.m_128359_((String)jsonElementEntry.getKey(), ((JsonElement)jsonElementEntry.getValue()).getAsString());
            }
        }
        Version version = new Version(metadata.version);
        if (version.invalid) {
            version = FiguraMod.VERSION;
        }
        nbt.m_128359_("name", metadata.name == null || metadata.name.isBlank() ? filename : metadata.name);
        nbt.m_128359_("ver", version.toString());
        if (metadata.color != null) {
            nbt.m_128359_("color", metadata.color);
        }
        if (metadata.background != null) {
            nbt.m_128359_("bg", metadata.background);
        }
        if (metadata.id != null) {
            nbt.m_128359_("id", metadata.id);
        }
        if (metadata.authors != null) {
            StringBuilder authors = new StringBuilder();
            for (int i = 0; i < metadata.authors.length; ++i) {
                String name2 = metadata.authors[i];
                authors.append(name2);
                if (i >= metadata.authors.length - 1) continue;
                authors.append("\n");
            }
            nbt.m_128359_("authors", authors.toString());
        } else {
            nbt.m_128359_("authors", metadata.author == null ? "?" : metadata.author);
        }
        if (metadata.autoScripts != null) {
            ListTag autoScripts = new ListTag();
            String[] stringArray = metadata.autoScripts;
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                name = stringArray[n];
                autoScripts.add((Object)StringTag.m_129297_((String)PathUtils.computeSafeString(name.replaceAll("\\.lua$", ""))));
            }
            nbt.m_128365_("autoScripts", (Tag)autoScripts);
        }
        if ((Integer)Configs.FORMAT_SCRIPT.value >= 2) {
            nbt.m_128379_("minify", true);
        }
        if (metadata.autoAnims != null) {
            ListTag autoAnims = new ListTag();
            String[] stringArray = metadata.autoAnims;
            int n3 = stringArray.length;
            for (n = 0; n < n3; ++n) {
                name = stringArray[n];
                autoAnims.add((Object)StringTag.m_129297_((String)name));
            }
            nbt.m_128365_("autoAnims", (Tag)autoAnims);
        }
        if (metadata.resources != null) {
            ListTag resourcesPaths = new ListTag();
            for (String resource : metadata.resources) {
                resourcesPaths.add((Object)StringTag.m_129297_((String)resource));
            }
            nbt.m_128365_("resources_paths", (Tag)resourcesPaths);
        }
        return nbt;
    }

    public static void injectToModels(Metadata metadata, CompoundTag models) throws IOException {
        PARTS_TO_MOVE.clear();
        if (metadata != null && metadata.customizations != null) {
            for (Map.Entry<String, Object> entry : metadata.customizations.entrySet()) {
                AvatarMetadataParser.injectCustomization(entry.getKey(), (Customization)entry.getValue(), models);
            }
        }
        for (Map.Entry<String, Object> entry : PARTS_TO_MOVE.entrySet()) {
            CompoundTag modelPart = AvatarMetadataParser.getTag(models, entry.getKey(), true);
            CompoundTag targetPart = AvatarMetadataParser.getTag(models, (String)entry.getValue(), false);
            ListTag list = !targetPart.m_128441_("chld") ? new ListTag() : targetPart.m_128437_("chld", 10);
            list.add((Object)modelPart);
            targetPart.m_128365_("chld", (Tag)list);
        }
    }

    public static void injectToTextures(Metadata metadata, CompoundTag textures) {
        if (metadata == null || metadata.ignoredTextures == null) {
            return;
        }
        CompoundTag src = textures.m_128469_("src");
        for (String texture : metadata.ignoredTextures) {
            byte[] bytes = src.m_128463_(texture);
            int[] size = BlockbenchModelParser.getTextureSize(bytes);
            ListTag list = new ListTag();
            list.add((Object)IntTag.m_128679_((int)size[0]));
            list.add((Object)IntTag.m_128679_((int)size[1]));
            src.m_128365_(texture, (Tag)list);
        }
    }

    private static void injectCustomization(String path, Customization customization, CompoundTag models) throws IOException {
        boolean remove = customization.remove != null && customization.remove != false;
        CompoundTag modelPart = AvatarMetadataParser.getTag(models, path, remove);
        if (remove) {
            return;
        }
        if (customization.primaryRenderType != null) {
            try {
                modelPart.m_128359_("primary", RenderTypes.valueOf(customization.primaryRenderType.toUpperCase(Locale.US)).name());
            }
            catch (Exception ignored) {
                throw new IOException("Invalid render type \"" + customization.primaryRenderType + "\"!");
            }
        }
        if (customization.secondaryRenderType != null) {
            try {
                modelPart.m_128359_("secondary", RenderTypes.valueOf(customization.secondaryRenderType.toUpperCase(Locale.US)).name());
            }
            catch (Exception ignored) {
                throw new IOException("Invalid render type \"" + customization.secondaryRenderType + "\"!");
            }
        }
        if (customization.parentType != null) {
            ParentType type = ParentType.get(customization.parentType);
            if (type == ParentType.None) {
                modelPart.m_128473_("pt");
            } else {
                modelPart.m_128359_("pt", type.name());
            }
        }
        if (customization.moveTo != null) {
            PARTS_TO_MOVE.put(path, customization.moveTo);
        }
        if (customization.visible != null) {
            if (customization.visible.booleanValue()) {
                modelPart.m_128473_("vsb");
            } else {
                modelPart.m_128379_("vsb", false);
            }
        }
        if (customization.smooth != null) {
            modelPart.m_128379_("smo", customization.smooth.booleanValue());
        }
    }

    private static CompoundTag getTag(CompoundTag models, String path, boolean remove) throws IOException {
        String[] keys = path.replaceFirst("^models", "").split("\\.", 0);
        CompoundTag current = models;
        for (int i = 0; i < keys.length; ++i) {
            int j;
            if (keys[i].isEmpty()) continue;
            if (!current.m_128441_("chld")) {
                throw new IOException("Invalid part path: \"" + path + "\"");
            }
            ListTag children = current.m_128437_("chld", 10);
            for (j = 0; j < children.size(); ++j) {
                CompoundTag child = children.m_128728_(j);
                if (child.m_128461_("name").equals(keys[i])) {
                    current = child;
                    break;
                }
                if (j != children.size() - 1) continue;
                throw new IOException("Invalid part path: \"" + path + "\"");
            }
            if (!remove || i != keys.length - 1) continue;
            children.remove(j);
        }
        return current;
    }

    public static class Metadata {
        public String name;
        public String description;
        public String author;
        public String version;
        public String color;
        public String background;
        public String id;
        public String[] authors;
        public String[] autoScripts;
        public String[] autoAnims;
        public String[] ignoredTextures;
        public String[] resources;
        public HashMap<String, Customization> customizations;
    }

    public static class Customization {
        public String primaryRenderType;
        public String secondaryRenderType;
        public String parentType;
        public String moveTo;
        public Boolean visible;
        public Boolean remove;
        public Boolean smooth;
    }
}

