/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.model.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.math.matrix.FiguraMat3;
import org.figuramc.figura.math.matrix.FiguraMat4;
import org.figuramc.figura.model.FiguraModelPart;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.model.VanillaModelData;
import org.figuramc.figura.model.rendering.PartFilterScheme;
import org.figuramc.figura.model.rendering.texture.FiguraTexture;
import org.figuramc.figura.model.rendering.texture.FiguraTextureSet;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public abstract class AvatarRenderer {
    protected final Avatar avatar;
    public FiguraModelPart root;
    protected final Map<ParentType, List<FiguraModelPart>> separatedParts = new ConcurrentHashMap<ParentType, List<FiguraModelPart>>();
    protected boolean isRendering;
    protected boolean dirty;
    public Entity entity;
    public float yaw;
    public float tickDelta;
    public int light;
    public int overlay;
    public float alpha;
    public boolean translucent;
    public boolean glowing;
    public FiguraMat4 posMat = FiguraMat4.of();
    public FiguraMat3 normalMat = FiguraMat3.of();
    public MultiBufferSource bufferSource;
    public VanillaModelData vanillaModelData = new VanillaModelData();
    public PartFilterScheme currentFilterScheme;
    public final HashMap<ParentType, ConcurrentLinkedQueue<Pair<FiguraMat4, FiguraMat3>>> pivotCustomizations = new HashMap(ParentType.values().length);
    protected final List<FiguraTextureSet> textureSets = new ArrayList<FiguraTextureSet>();
    public final HashMap<String, FiguraTexture> textures = new HashMap();
    public final HashMap<String, FiguraTexture> customTextures = new HashMap();
    protected static int shouldRenderPivots;
    public boolean allowMatrixUpdate = false;
    public boolean allowHiddenTransforms = true;
    public boolean interceptRendersIntoFigura = true;
    public boolean allowPivotParts = true;
    public boolean updateLight = false;
    public boolean doIrisEmissiveFix = false;
    public boolean offsetRenderLayers = false;
    public boolean ignoreVanillaVisibility = false;
    public FiguraModelPart itemToRender;

    public AvatarRenderer(Avatar avatar) {
        this.avatar = avatar;
        CompoundTag nbt = avatar.nbt.m_128469_("textures");
        CompoundTag src = nbt.m_128469_("src");
        for (String key : src.m_128431_()) {
            byte[] bytes = src.m_128463_(key);
            if (bytes.length > 0) {
                this.textures.put(key, new FiguraTexture(avatar, key, bytes));
                continue;
            }
            ListTag size = src.m_128437_(key, 3);
            this.textures.put(key, new FiguraTexture(avatar, key, size.m_128763_(0), size.m_128763_(1)));
        }
        ListTag texturesList = nbt.m_128437_("data", 10);
        for (Tag t : texturesList) {
            CompoundTag tag = (CompoundTag)t;
            this.textureSets.add(new FiguraTextureSet(this.getTextureName(tag), this.textures.get(tag.m_128461_("d")), this.textures.get(tag.m_128461_("e")), this.textures.get(tag.m_128461_("s")), this.textures.get(tag.m_128461_("n"))));
        }
        avatar.hasTexture = !texturesList.isEmpty();
    }

    private String getTextureName(CompoundTag tag) {
        String s = tag.m_128461_("d");
        if (!s.isEmpty()) {
            return s;
        }
        s = tag.m_128461_("e");
        if (!s.isEmpty()) {
            return s.substring(0, s.length() - 2);
        }
        s = tag.m_128461_("s");
        if (!s.isEmpty()) {
            return s.substring(0, s.length() - 2);
        }
        s = tag.m_128461_("n");
        if (!s.isEmpty()) {
            return s.substring(0, s.length() - 2);
        }
        return "";
    }

    public FiguraTexture getTexture(String name) {
        FiguraTexture texture = this.customTextures.get(name);
        if (texture != null) {
            return texture;
        }
        for (Map.Entry<String, FiguraTexture> entry : this.textures.entrySet()) {
            if (!entry.getKey().equals(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    public abstract int render();

    public abstract int renderSpecialParts();

    public abstract void updateMatrices();

    protected void clean() {
        for (FiguraTextureSet set : this.textureSets) {
            set.clean();
        }
        for (FiguraTexture texture : this.customTextures.values()) {
            texture.close();
        }
    }

    public void invalidate() {
        this.dirty = true;
        if (!this.isRendering) {
            this.clean();
        }
    }

    public void sortParts() {
        this.separatedParts.clear();
        this._sortParts(this.root);
    }

    private void _sortParts(FiguraModelPart part) {
        if (part.parentType.isSeparate) {
            List list = this.separatedParts.computeIfAbsent(part.parentType, parentType -> new ArrayList());
            list.add(part);
        }
        for (FiguraModelPart child : part.children) {
            this._sortParts(child);
        }
    }

    public static FiguraMat4 entityToWorldMatrix(Entity e, float delta) {
        float f;
        if (e instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)e;
            f = Mth.m_14179_((float)delta, (float)le.f_20884_, (float)le.f_20883_);
        } else {
            f = e.m_5675_(Minecraft.m_91087_().m_91296_());
        }
        double yaw = f;
        FiguraMat4 result = FiguraMat4.of();
        result.rotateX(180.0 - yaw);
        result.translate(e.m_20318_(delta));
        return result;
    }

    public static double getYawOffsetRot(Entity e, float delta) {
        float f;
        if (e instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)e;
            f = Mth.m_14179_((float)delta, (float)le.f_20884_, (float)le.f_20883_);
        } else {
            f = e.m_5675_(Minecraft.m_91087_().m_91296_());
        }
        double yaw = f;
        return 180.0 - yaw;
    }

    public static FiguraMat4 worldToViewMatrix() {
        Minecraft client = Minecraft.m_91087_();
        Camera camera = client.f_91063_.m_109153_();
        Matrix3f cameraMat3f = new Matrix3f().rotation((Quaternionfc)camera.m_253121_());
        cameraMat3f.invert();
        FiguraMat4 result = FiguraMat4.of();
        Vec3 cameraPos = camera.m_90583_().m_82490_(-1.0);
        result.translate(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_);
        FiguraMat3 cameraMat = FiguraMat3.of().set(cameraMat3f);
        result.multiply(cameraMat.augmented());
        result.scale(-1.0, 1.0, -1.0);
        return result;
    }

    public void setupRenderer(PartFilterScheme currentFilterScheme, MultiBufferSource bufferSource, PoseStack matrices, float tickDelta, int light, float alpha, int overlay, boolean translucent, boolean glowing) {
        this.setupRenderer(currentFilterScheme, bufferSource, tickDelta, light, alpha, overlay, translucent, glowing);
        this.setMatrices(matrices);
    }

    public void setupRenderer(PartFilterScheme currentFilterScheme, MultiBufferSource bufferSource, PoseStack matrices, float tickDelta, int light, float alpha, int overlay, boolean translucent, boolean glowing, double camX, double camY, double camZ) {
        this.setupRenderer(currentFilterScheme, bufferSource, tickDelta, light, alpha, overlay, translucent, glowing);
        this.setMatrices(camX, camY, camZ, matrices);
    }

    private void setupRenderer(PartFilterScheme currentFilterScheme, MultiBufferSource bufferSource, float tickDelta, int light, float alpha, int overlay, boolean translucent, boolean glowing) {
        this.currentFilterScheme = currentFilterScheme;
        this.bufferSource = bufferSource;
        this.tickDelta = tickDelta;
        this.light = light;
        this.alpha = alpha;
        this.overlay = overlay;
        this.translucent = translucent;
        this.glowing = glowing;
    }

    public void setMatrices(PoseStack matrices) {
        PoseStack.Pose pose = matrices.m_85850_();
        this.posMat.set(pose.m_252922_());
        this.normalMat.set(pose.m_252943_());
    }

    public void setMatrices(double camX, double camY, double camZ, PoseStack matrices) {
        PoseStack.Pose pose = matrices.m_85850_();
        Matrix4d posMat = new Matrix4d((Matrix4fc)pose.m_252922_());
        posMat.translate(-camX, -camY, -camZ);
        posMat.scale(-1.0, -1.0, 1.0);
        this.posMat.set(posMat);
        Matrix3f normalMat = new Matrix3f((Matrix3fc)pose.m_252943_());
        normalMat.scale(-1.0f, -1.0f, 1.0f);
        this.normalMat.set(normalMat);
    }
}

