/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render.renderers;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.ducks.EntityRendererAccessor;
import org.figuramc.figura.lua.api.nameplate.EntityNameplateCustomization;
import org.figuramc.figura.lua.api.vanilla_model.VanillaGroupPart;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.RenderUtils;
import org.figuramc.figura.utils.TextUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>
implements EntityRendererAccessor {
    @Unique
    private Avatar avatar;
    @Unique
    boolean isNameRendering;
    @Unique
    boolean hasScore;

    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> entityModel, float shadowRadius) {
        super(context, entityModel, shadowRadius);
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;renderNameTag(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", ordinal=1)})
    private void enableModifyPlayerName(AbstractClientPlayer player, Component text, PoseStack stack, MultiBufferSource multiBufferSource, int light, CallbackInfo ci) {
        FiguraMod.popPushProfiler("name");
        this.isNameRendering = true;
    }

    @Override
    public boolean figura$isRenderingName() {
        return this.isNameRendering;
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="TAIL")})
    private void disableModifyPlayerName(AbstractClientPlayer player, Component text, PoseStack stack, MultiBufferSource multiBufferSource, int light, CallbackInfo ci) {
        this.isNameRendering = false;
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/scores/Scoreboard;getDisplayObjective(I)Lnet/minecraft/world/scores/Objective;")})
    private void setHasScore(AbstractClientPlayer player, Component text, PoseStack stack, MultiBufferSource multiBufferSource, int light, CallbackInfo ci) {
        Scoreboard scoreboard = player.m_36329_();
        Objective objective = scoreboard.m_83416_(2);
        this.hasScore = objective != null;
    }

    @Override
    public boolean figura$hasScore() {
        return this.hasScore;
    }

    @ModifyArg(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;renderNameTag(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", ordinal=1))
    private Component modifyPlayerNameText(Component text, @Local(argsOnly=true) AbstractClientPlayer player) {
        int config = (Integer)Configs.ENTITY_NAMEPLATE.value;
        if (config == 0 || AvatarManager.panic) {
            return text;
        }
        Avatar avatar = AvatarManager.getAvatarForPlayer(player.m_20148_());
        EntityNameplateCustomization custom = avatar == null || avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.ENTITY;
        boolean hasCustom = custom != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1;
        MutableComponent name = Component.m_237113_((String)player.m_7755_().getString());
        FiguraMod.popPushProfiler("text");
        MutableComponent replacement = hasCustom && custom.getJson() != null ? custom.getJson().m_6881_() : name;
        replacement = TextUtils.replaceInText((FormattedText)replacement, "\\$\\{name\\}", name);
        FiguraMod.popPushProfiler("badges");
        replacement = Badges.appendBadges((Component)replacement, player.m_20148_(), config > 1);
        FiguraMod.popPushProfiler("applyName");
        text = TextUtils.replaceInText((FormattedText)text, "\\b" + Pattern.quote(player.m_7755_().getString()) + "\\b", replacement);
        return text;
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V")})
    private void pushProfilerForRender(AbstractClientPlayer player, Component text, PoseStack stack, MultiBufferSource multiBufferSource, int light, CallbackInfo ci) {
        FiguraMod.popPushProfiler("render");
        FiguraMod.pushProfiler("scoreboard");
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="TAIL")})
    private void popProfiler(AbstractClientPlayer player, Component text, PoseStack stack, MultiBufferSource multiBufferSource, int light, CallbackInfo ci) {
        FiguraMod.popProfiler(5);
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderNameTag(AbstractClientPlayer player, Component text, PoseStack stack, MultiBufferSource multiBufferSource, int light, CallbackInfo ci) {
        boolean hasCustom;
        int config = (Integer)Configs.ENTITY_NAMEPLATE.value;
        if (config == 0 || AvatarManager.panic || this.f_114476_.m_114471_((Entity)player) > 4096.0) {
            return;
        }
        Avatar avatar = AvatarManager.getAvatarForPlayer(player.m_20148_());
        EntityNameplateCustomization custom = avatar == null || avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.ENTITY;
        boolean bl = hasCustom = custom != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1;
        if (custom != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 0) {
            avatar.noPermissions.add(Permissions.NAMEPLATE_EDIT);
        } else if (avatar != null) {
            avatar.noPermissions.remove(Permissions.NAMEPLATE_EDIT);
        }
        if (hasCustom && !custom.visible) {
            ci.cancel();
            return;
        }
        if (hasCustom) {
            FiguraMod.pushProfiler("figura");
            FiguraMod.pushProfiler(player.m_7755_().getString());
            FiguraMod.pushProfiler("nameplate");
        }
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/model/PlayerModel;setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V")}, method={"renderHand"})
    private void onRenderHand(PoseStack stack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, CallbackInfo ci) {
        this.avatar = AvatarManager.getAvatarForPlayer(player.m_20148_());
        if (this.avatar != null && this.avatar.luaRuntime != null) {
            VanillaGroupPart part = this.avatar.luaRuntime.vanilla_model.PLAYER;
            PlayerModel model = (PlayerModel)this.m_7200_();
            ((VanillaPart)part).save((EntityModel<?>)model);
            if (this.avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
                ((VanillaPart)part).preTransform((EntityModel<?>)model);
                ((VanillaPart)part).posTransform((EntityModel<?>)model);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderHand"})
    private void postRenderHand(PoseStack stack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, CallbackInfo ci) {
        if (this.avatar == null) {
            return;
        }
        float delta = Minecraft.m_91087_().m_91296_();
        this.avatar.firstPersonRender(stack, multiBufferSource, (Player)player, (PlayerRenderer)this, arm, light, delta);
        if (this.avatar.luaRuntime != null) {
            this.avatar.luaRuntime.vanilla_model.PLAYER.restore(this.m_7200_());
        }
        this.avatar = null;
    }

    @Inject(method={"setupRotations"}, at={@At(value="HEAD")}, cancellable=true)
    private void setupRotations(AbstractClientPlayer entity, PoseStack poseStack, float f, float f2, float f3, CallbackInfo cir) {
        Avatar avatar = AvatarManager.getAvatar((Entity)entity);
        if (RenderUtils.vanillaModelAndScript(avatar) && !avatar.luaRuntime.renderer.getRootRotationAllowed().booleanValue()) {
            cir.cancel();
        }
    }
}

