/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.compat.GeckoLibCompat;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.mixin.render.layers.HumanoidArmorLayerAccessor;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.FiguraArmorPartRenderer;
import org.figuramc.figura.utils.RenderUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidArmorLayer.class}, priority=900)
public abstract class HumanoidArmorLayerMixin<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M>
implements HumanoidArmorLayerAccessor<T, M, A> {
    @Shadow
    @Final
    private TextureAtlas f_266073_;
    @Shadow
    @Final
    private A f_117071_;
    @Shadow
    @Final
    private A f_117072_;
    @Unique
    private boolean figura$renderingVanillaArmor;
    @Unique
    private Avatar figura$avatar;

    @Shadow
    protected abstract A m_117078_(EquipmentSlot var1);

    @Shadow
    protected abstract void m_117118_(PoseStack var1, MultiBufferSource var2, T var3, EquipmentSlot var4, int var5, A var6);

    public HumanoidArmorLayerMixin(RenderLayerParent<T, M> context) {
        super(context);
    }

    @Inject(at={@At(value="HEAD")}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"})
    public void setAvatar(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        this.figura$avatar = AvatarManager.getAvatar(livingEntity);
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, ordinal=3, target="Lnet/minecraft/client/renderer/entity/layers/HumanoidArmorLayer;renderArmorPiece(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/EquipmentSlot;ILnet/minecraft/client/model/HumanoidModel;)V")}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"})
    public void onRenderEnd(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        if (this.figura$avatar == null) {
            return;
        }
        this.figura$tryRenderArmorPart(EquipmentSlot.HEAD, this::figura$helmetRenderer, poseStack, livingEntity, multiBufferSource, i, ParentType.HelmetPivot);
        this.figura$tryRenderArmorPart(EquipmentSlot.CHEST, this::figura$chestplateRenderer, poseStack, livingEntity, multiBufferSource, i, ParentType.LeftShoulderPivot, ParentType.ChestplatePivot, ParentType.RightShoulderPivot);
        this.figura$tryRenderArmorPart(EquipmentSlot.LEGS, this::figura$leggingsRenderer, poseStack, livingEntity, multiBufferSource, i, ParentType.LeftLeggingPivot, ParentType.RightLeggingPivot, ParentType.LeggingsPivot);
        this.figura$tryRenderArmorPart(EquipmentSlot.FEET, this::figura$bootsRenderer, poseStack, livingEntity, multiBufferSource, i, ParentType.LeftBootPivot, ParentType.RightBootPivot);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/HumanoidArmorLayer;usesInnerModel(Lnet/minecraft/world/entity/EquipmentSlot;)Z")}, method={"renderArmorPiece"})
    public void onRenderArmorPiece(PoseStack poseStack, MultiBufferSource multiBufferSource, T livingEntity, EquipmentSlot equipmentSlot, int i, A humanoidModel, CallbackInfo ci) {
        if (this.figura$avatar == null) {
            return;
        }
        VanillaPart part = RenderUtils.partFromSlot(this.figura$avatar, equipmentSlot);
        if (part != null) {
            part.save((EntityModel<?>)humanoidModel);
            part.preTransform((EntityModel<?>)humanoidModel);
            part.posTransform((EntityModel<?>)humanoidModel);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/HumanoidArmorLayer;setPartVisibility(Lnet/minecraft/client/model/HumanoidModel;Lnet/minecraft/world/entity/EquipmentSlot;)V", shift=At.Shift.AFTER)}, method={"renderArmorPiece"}, cancellable=true)
    public void renderArmorPieceHijack(PoseStack poseStack, MultiBufferSource multiBufferSource, T livingEntity, EquipmentSlot equipmentSlot, int i, A humanoidModel, CallbackInfo ci) {
        if (this.figura$avatar == null) {
            return;
        }
        if (!this.figura$renderingVanillaArmor) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderArmorPiece"})
    public void postRenderArmorPiece(PoseStack poseStack, MultiBufferSource multiBufferSource, T livingEntity, EquipmentSlot equipmentSlot, int i, A humanoidModel, CallbackInfo ci) {
        if (this.figura$avatar == null) {
            return;
        }
        VanillaPart part = RenderUtils.partFromSlot(this.figura$avatar, equipmentSlot);
        if (part != null) {
            part.restore((EntityModel<?>)humanoidModel);
        }
    }

    @Unique
    private void figura$tryRenderArmorPart(EquipmentSlot slot, FiguraArmorPartRenderer<T, M, A> renderer, PoseStack vanillaPoseStack, T entity, MultiBufferSource vertexConsumers, int light, ParentType ... parentTypes) {
        ArmorItem armorItem;
        if (slot == null) {
            return;
        }
        ItemStack itemStack = entity.m_6844_(slot);
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == slot) {
            A armorModel = this.m_117078_(slot);
            ((HumanoidModel)armorModel).f_102810_.f_104203_ = 0.0f;
            ((HumanoidModel)armorModel).f_102813_.f_104202_ = 0.0f;
            ((HumanoidModel)armorModel).f_102814_.f_104202_ = 0.0f;
            ((HumanoidModel)armorModel).f_102813_.f_104201_ = 12.0f;
            ((HumanoidModel)armorModel).f_102814_.f_104201_ = 12.0f;
            ((HumanoidModel)armorModel).f_102808_.f_104201_ = 0.0f;
            ((HumanoidModel)armorModel).f_102810_.f_104201_ = 0.0f;
            ((HumanoidModel)armorModel).f_102812_.f_104201_ = 2.0f;
            ((HumanoidModel)armorModel).f_102811_.f_104201_ = 2.0f;
            ((HumanoidModel)armorModel).f_102812_.f_104200_ = 5.0f;
            ((HumanoidModel)armorModel).f_102811_.f_104200_ = -5.0f;
            ((HumanoidModel)armorModel).f_102812_.f_104202_ = 0.0f;
            ((HumanoidModel)armorModel).f_102811_.f_104202_ = 0.0f;
            boolean allFailed = true;
            VanillaPart mainPart = RenderUtils.partFromSlot(this.figura$avatar, slot);
            int armorEditPermission = this.figura$avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT);
            if (armorEditPermission == 1 && mainPart != null && !mainPart.checkVisible()) {
                return;
            }
            if (!GeckoLibCompat.armorHasCustomModel(itemStack)) {
                for (ParentType parentType : parentTypes) {
                    VanillaPart part = RenderUtils.pivotToPart(this.figura$avatar, parentType);
                    if (armorEditPermission == 1 && part != null && !part.checkVisible()) continue;
                    boolean renderedPivot = false;
                    if (armorEditPermission == 1) {
                        renderedPivot = this.figura$avatar.pivotPartRender(parentType, stack -> {
                            stack.m_85836_();
                            this.figura$prepareArmorRender((PoseStack)stack);
                            renderer.renderArmorPart((PoseStack)stack, vertexConsumers, light, armorModel, entity, itemStack, slot, armorItem, parentType);
                            stack.m_85849_();
                        });
                    }
                    if (!renderedPivot) continue;
                    allFailed = false;
                }
            }
            if (allFailed) {
                this.figura$renderingVanillaArmor = true;
                this.m_117118_(vanillaPoseStack, vertexConsumers, entity, slot, light, armorModel);
                this.figura$renderingVanillaArmor = false;
            }
        }
    }

    @Unique
    private void figura$prepareArmorRender(PoseStack stack) {
        stack.m_85841_(16.0f, 16.0f, 16.0f);
        stack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
    }

    @Unique
    private void figura$helmetRenderer(PoseStack poseStack, MultiBufferSource vertexConsumers, int light, A model, T entity, ItemStack itemStack, EquipmentSlot armorSlot, ArmorItem armorItem, ParentType parentType) {
        if (parentType == ParentType.HelmetPivot) {
            this.figura$renderArmorPart(((HumanoidModel)model).f_102808_, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            this.figura$renderArmorPart(((HumanoidModel)model).f_102809_, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
        }
    }

    @Unique
    private void figura$chestplateRenderer(PoseStack poseStack, MultiBufferSource vertexConsumers, int light, A model, T entity, ItemStack itemStack, EquipmentSlot armorSlot, ArmorItem armorItem, ParentType parentType) {
        if (parentType == ParentType.ChestplatePivot) {
            this.figura$renderArmorPart(((HumanoidModel)model).f_102810_, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
        }
        if (parentType == ParentType.LeftShoulderPivot) {
            poseStack.m_85836_();
            poseStack.m_252880_(-0.375f, 0.0f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).f_102812_, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.m_85849_();
        }
        if (parentType == ParentType.RightShoulderPivot) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.375f, 0.0f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).f_102811_, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.m_85849_();
        }
    }

    @Unique
    private void figura$leggingsRenderer(PoseStack poseStack, MultiBufferSource vertexConsumers, int light, A model, T entity, ItemStack itemStack, EquipmentSlot armorSlot, ArmorItem armorItem, ParentType parentType) {
        if (parentType == ParentType.LeggingsPivot) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, -0.75f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).f_102810_, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.m_85849_();
        }
        if (parentType == ParentType.LeftLeggingPivot) {
            poseStack.m_85836_();
            poseStack.m_252880_(-0.125f, -0.75f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).f_102814_, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.m_85849_();
        }
        if (parentType == ParentType.RightLeggingPivot) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.125f, -0.75f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).f_102813_, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.m_85849_();
        }
    }

    @Unique
    private void figura$bootsRenderer(PoseStack poseStack, MultiBufferSource vertexConsumers, int light, A model, T entity, ItemStack itemStack, EquipmentSlot armorSlot, ArmorItem armorItem, ParentType parentType) {
        if (parentType == ParentType.LeftBootPivot) {
            poseStack.m_85836_();
            poseStack.m_252880_(-0.125f, -1.5f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).f_102814_, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.m_85849_();
        }
        if (parentType == ParentType.RightBootPivot) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.125f, -1.5f, 0.0f);
            this.figura$renderArmorPart(((HumanoidModel)model).f_102813_, poseStack, vertexConsumers, light, entity, itemStack, armorSlot, armorItem);
            poseStack.m_85849_();
        }
    }

    @Unique
    private void figura$renderArmorPart(ModelPart modelPart, PoseStack poseStack, MultiBufferSource vertexConsumers, int light, T entity, ItemStack itemStack, EquipmentSlot armorSlot, ArmorItem armorItem) {
        boolean bl = this.usesInnerModel(armorSlot);
        boolean hasOverlay = false;
        boolean hasGlint = itemStack.m_41790_();
        modelPart.f_104207_ = true;
        modelPart.f_104203_ = 0.0f;
        modelPart.f_104204_ = 0.0f;
        modelPart.f_104205_ = 0.0f;
        float tintR = 1.0f;
        float tintG = 1.0f;
        float tintB = 1.0f;
        if (armorItem instanceof DyeableArmorItem) {
            DyeableArmorItem dyeableArmorItem = (DyeableArmorItem)armorItem;
            int i = dyeableArmorItem.m_41121_(itemStack);
            tintR = (float)(i >> 16 & 0xFF) / 255.0f;
            tintG = (float)(i >> 8 & 0xFF) / 255.0f;
            tintB = (float)(i & 0xFF) / 255.0f;
            hasOverlay = true;
        }
        ResourceLocation normalArmorResource = RenderUtils.getArmorResource((HumanoidArmorLayer)this, entity, itemStack, armorItem, armorSlot, bl, null);
        VertexConsumer regularArmorConsumer = vertexConsumers.m_6299_(RenderType.m_110431_((ResourceLocation)normalArmorResource));
        modelPart.m_104306_(poseStack, regularArmorConsumer, light, OverlayTexture.f_118083_, tintR, tintG, tintB, 1.0f);
        if (hasOverlay) {
            VertexConsumer overlaidArmorConsumer = vertexConsumers.m_6299_(RenderType.m_110431_((ResourceLocation)RenderUtils.getArmorResource((HumanoidArmorLayer)this, entity, itemStack, armorItem, armorSlot, bl, "overlay")));
            modelPart.m_104306_(poseStack, overlaidArmorConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        ArmorTrim.m_266285_((RegistryAccess)entity.m_9236_().m_9598_(), (ItemStack)itemStack).ifPresent(permutation -> {
            ArmorMaterial armorMaterial = armorItem.m_40401_();
            TextureAtlasSprite trimAtlas = this.f_266073_.m_118316_(bl ? permutation.m_267774_(armorMaterial) : permutation.m_267606_(armorMaterial));
            VertexConsumer trimConsumer = trimAtlas.m_118381_(vertexConsumers.m_6299_(Sheets.m_266442_()));
            modelPart.m_104306_(poseStack, trimConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        });
        if (hasGlint) {
            modelPart.m_104306_(poseStack, vertexConsumers.m_6299_(RenderType.m_110484_()), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

