/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.ducks.GameRendererAccessor;
import org.figuramc.figura.lua.api.ClientAPI;
import org.figuramc.figura.math.matrix.FiguraMat3;
import org.figuramc.figura.math.matrix.FiguraMat4;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.RenderUtils;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin
implements GameRendererAccessor {
    @Shadow
    @Final
    Minecraft f_109059_;
    @Shadow
    PostChain f_109050_;
    @Shadow
    private boolean f_109053_;
    @Shadow
    private float f_109066_;
    @Unique
    private boolean avatarPostShader = false;
    @Unique
    private Matrix4f bobbingMatrix;
    @Unique
    private boolean hasShaders;

    @Shadow
    protected abstract double m_109141_(Camera var1, float var2, boolean var3);

    @Shadow
    abstract void m_109128_(ResourceLocation var1);

    @Shadow
    public abstract void m_109106_(Entity var1);

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V", shift=At.Shift.BEFORE)})
    private void onCameraRotation(float tickDelta, long limitTime, PoseStack stack, CallbackInfo ci) {
        FiguraMat3 normal;
        FiguraVec3 offset;
        Avatar avatar = AvatarManager.getAvatar((Entity)(this.f_109059_.m_91288_() == null ? this.f_109059_.f_91074_ : this.f_109059_.m_91288_()));
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return;
        }
        float z = 0.0f;
        FiguraVec3 rot = avatar.luaRuntime.renderer.cameraRot;
        if (rot != null) {
            z = (float)rot.z;
        }
        if ((offset = avatar.luaRuntime.renderer.cameraOffsetRot) != null) {
            z += (float)offset.z;
        }
        stack.m_252781_(Axis.f_252403_.m_252977_(z));
        FiguraMat4 mat = avatar.luaRuntime.renderer.cameraMat;
        if (mat != null) {
            stack.m_85850_().m_252922_().set((Matrix4fc)mat.toMatrix4f());
        }
        if ((normal = avatar.luaRuntime.renderer.cameraNormal) != null) {
            stack.m_85850_().m_252943_().set((Matrix3fc)normal.toMatrix3f());
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;doEntityOutline()V", shift=At.Shift.AFTER)})
    private void render(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        Entity entity = this.f_109059_.m_91288_();
        Avatar avatar = AvatarManager.getAvatar(entity);
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            if (this.avatarPostShader) {
                this.avatarPostShader = false;
                this.m_109106_(entity);
            }
            return;
        }
        ResourceLocation resource = avatar.luaRuntime.renderer.postShader;
        if (resource == null) {
            if (this.avatarPostShader) {
                this.avatarPostShader = false;
                this.m_109106_(entity);
            }
            return;
        }
        try {
            this.avatarPostShader = true;
            this.f_109053_ = true;
            if (this.f_109050_ == null || !this.f_109050_.m_110022_().equals(resource.toString())) {
                this.m_109128_(resource);
            }
        }
        catch (Exception ignored) {
            this.f_109053_ = false;
            avatar.luaRuntime.renderer.postShader = null;
        }
    }

    @Inject(method={"checkEntityPostEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkEntityPostEffect(Entity entity, CallbackInfo ci) {
        if (this.avatarPostShader) {
            ci.cancel();
        }
    }

    @Inject(method={"tickFov"}, at={@At(value="RETURN")})
    private void tickFov(CallbackInfo ci) {
        Float fov;
        Avatar avatar = AvatarManager.getAvatar(this.f_109059_.m_91288_());
        if (RenderUtils.vanillaModelAndScript(avatar) && (fov = avatar.luaRuntime.renderer.fov) != null) {
            this.f_109066_ = fov.floatValue();
        }
    }

    @Inject(method={"pick"}, at={@At(value="RETURN")})
    private void pick(float tickDelta, CallbackInfo ci) {
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler("extendedPick");
        FiguraMod.extendedPickEntity = EntityUtils.getViewedEntity(32.0f);
        FiguraMod.popProfiler(2);
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void onRenderLevel(float tickDelta, long limitTime, PoseStack stack, CallbackInfo ci) {
        this.hasShaders = ClientAPI.hasShaderPack();
    }

    @ModifyArg(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"), index=0)
    private PoseStack renderLevelBobHurt(PoseStack stack) {
        if (this.hasShaders) {
            return stack;
        }
        stack.m_85836_();
        stack.m_85850_().m_252922_().identity();
        return stack;
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;last()Lcom/mojang/blaze3d/vertex/PoseStack$Pose;", shift=At.Shift.BEFORE)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"), to=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;resetProjectionMatrix(Lorg/joml/Matrix4f;)V"))}, locals=LocalCapture.CAPTURE_FAILSOFT, require=0)
    private void renderLevelSaveBobbing(float tickDelta, long limitTime, PoseStack matrix, CallbackInfo ci, boolean bl, Camera camera, PoseStack poseStack, double d) {
        if (this.hasShaders) {
            return;
        }
        this.bobbingMatrix = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        poseStack.m_85849_();
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;last()Lcom/mojang/blaze3d/vertex/PoseStack$Pose;", shift=At.Shift.BEFORE)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;bobHurt(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"), to=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;resetProjectionMatrix(Lorg/joml/Matrix4f;)V"))}, locals=LocalCapture.CAPTURE_FAILSOFT, require=0)
    private void renderLevelSaveBobbingOF(float tickDelta, long limitTime, PoseStack matrix, CallbackInfo ci, boolean bl, boolean bl2, Camera camera, PoseStack poseStack, double d) {
        if (this.hasShaders) {
            return;
        }
        this.bobbingMatrix = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        poseStack.m_85849_();
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;resetProjectionMatrix(Lorg/joml/Matrix4f;)V")})
    private void renderLevelResetProjectionMatrix(float tickDelta, long limitTime, PoseStack matrix, CallbackInfo ci) {
        if (this.hasShaders) {
            return;
        }
        matrix.m_85850_().m_252922_().mul((Matrix4fc)this.bobbingMatrix);
        this.bobbingMatrix = null;
    }

    @Override
    @Intrinsic
    public double figura$getFov(Camera camera, float tickDelta, boolean changingFov) {
        return this.m_109141_(camera, tickDelta, changingFov);
    }
}

