/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.Item;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.ducks.GeckolibGeoArmorAccessor;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.RenderUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

@Pseudo
@Mixin(value={GeoRenderer.class}, remap=false)
public interface GeckolibGeoRendererMixin<T extends GeoAnimatable> {
    @Shadow
    public void renderRecursively(PoseStack var1, GeoAnimatable var2, GeoBone var3, RenderType var4, MultiBufferSource var5, VertexConsumer var6, boolean var7, float var8, int var9, int var10, float var11, float var12, float var13, float var14);

    @Shadow
    public void updateAnimatedTextureFrame(T var1);

    @Overwrite
    default public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.updateAnimatedTextureFrame(animatable);
        CallbackInfo callbackInfo = new CallbackInfo("figura$renderPivots", true);
        this.figura$renderPivots(poseStack, (GeoAnimatable)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha, callbackInfo);
        if (callbackInfo.isCancelled()) {
            return;
        }
        for (GeoBone group : model.topLevelBones()) {
            this.renderRecursively(poseStack, (GeoAnimatable)animatable, group, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    @Unique
    default public void figura$renderPivots(PoseStack poseStack, GeoAnimatable geoAnimatable, BakedGeoModel model, RenderType renderType, MultiBufferSource multiBufferSource, VertexConsumer vertexConsumer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, CallbackInfo ci) {
        boolean allFailed = true;
        if (this instanceof GeoArmorRenderer && ((GeckolibGeoArmorAccessor)((Object)this)).figura$getAvatar() != null) {
            GeoArmorRenderer armorRenderer = (GeoArmorRenderer)this;
            if (armorRenderer.getCurrentSlot() == null) {
                return;
            }
            Avatar avatar = ((GeckolibGeoArmorAccessor)armorRenderer).figura$getAvatar();
            if (avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) < 1) {
                return;
            }
            switch (armorRenderer.getCurrentSlot()) {
                case HEAD: {
                    allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.HelmetPivot, geoAnimatable, armorRenderer.getHeadBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                    if (!allFailed) break;
                    this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getHeadBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                    break;
                }
                case CHEST: {
                    allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.ChestplatePivot, geoAnimatable, armorRenderer.getBodyBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                    if (allFailed) {
                        this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getBodyBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                    }
                    if (allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.LeftShoulderPivot, geoAnimatable, armorRenderer.getLeftArmBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha)) {
                        this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getLeftArmBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                    }
                    if (!(allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.RightShoulderPivot, geoAnimatable, armorRenderer.getRightArmBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha))) break;
                    this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getRightArmBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                    break;
                }
                case LEGS: {
                    allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.LeftLeggingPivot, geoAnimatable, armorRenderer.getLeftLegBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                    if (allFailed) {
                        this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getLeftLegBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                    }
                    this.figura$renderPivot(armorRenderer, avatar, ParentType.RightLeggingPivot, geoAnimatable, armorRenderer.getRightLegBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                    if (!allFailed) break;
                    this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getRightLegBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                    break;
                }
                case FEET: {
                    allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.LeftBootPivot, geoAnimatable, armorRenderer.getLeftBootBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                    if (allFailed) {
                        this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getLeftBootBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                    }
                    if (!(allFailed = this.figura$renderPivot(armorRenderer, avatar, ParentType.RightBootPivot, geoAnimatable, armorRenderer.getRightBootBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha))) break;
                    this.renderRecursively(poseStack, geoAnimatable, armorRenderer.getRightBootBone(), renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                    break;
                }
            }
            ci.cancel();
        }
    }

    @Unique
    default public boolean figura$renderPivot(GeoArmorRenderer armorRenderer, Avatar avatar, ParentType parentType, GeoAnimatable geoAnimatable, GeoBone geoBone, RenderType renderType, MultiBufferSource multiBufferSource, VertexConsumer vertexConsumer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (geoBone == null) {
            return true;
        }
        int armorEditPermission = avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT);
        VanillaPart part = RenderUtils.pivotToPart(avatar, parentType);
        if (armorEditPermission == 1 && part != null && !part.checkVisible()) {
            return false;
        }
        if (armorEditPermission != 1) {
            return true;
        }
        return !avatar.pivotPartRender(parentType, stack -> {
            geoBone.setRotX(0.0f);
            geoBone.setRotY(0.0f);
            geoBone.setRotZ(0.0f);
            stack.m_85836_();
            this.figura$prepareArmorRender((PoseStack)stack);
            this.figura$transformBasedOnType(geoBone, (PoseStack)stack, parentType);
            ((GeckolibGeoArmorAccessor)armorRenderer).figura$setEntityRenderTranslations(stack.m_85850_().m_252922_());
            stack.m_85836_();
            BakedGeoModel model = armorRenderer.getGeoModel().getBakedModel(armorRenderer.getGeoModel().getModelResource(geoAnimatable));
            armorRenderer.scaleModelForBaby(stack, (Item)geoAnimatable, partialTick, isReRender);
            armorRenderer.scaleModelForRender(((GeckolibGeoArmorAccessor)armorRenderer).figura$getScaleWidth(), ((GeckolibGeoArmorAccessor)armorRenderer).figura$getScaleHeight(), stack, geoAnimatable, model, isReRender, partialTick, packedLight, packedOverlay);
            stack.m_252880_(0.0f, 1.5f, 0.0f);
            stack.m_85841_(-1.0f, -1.0f, 1.0f);
            ((GeckolibGeoArmorAccessor)armorRenderer).figura$setModelRenderTranslations(stack.m_85850_().m_252922_());
            this.renderRecursively((PoseStack)stack, geoAnimatable, geoBone, renderType, multiBufferSource, vertexConsumer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            stack.m_85849_();
            stack.m_85849_();
        });
    }

    @Unique
    default public void figura$transformBasedOnType(GeoBone bone, PoseStack poseStack, ParentType parentType) {
        if (parentType == ParentType.LeftShoulderPivot) {
            bone.setPosY(0.0f);
            bone.setPosZ(0.0f);
            bone.setPosX(0.0f);
            poseStack.m_252880_(-0.375f, 0.0f, 0.0f);
        } else if (parentType == ParentType.RightShoulderPivot) {
            bone.setPosY(0.0f);
            bone.setPosZ(0.0f);
            bone.setPosX(0.0f);
            poseStack.m_252880_(0.375f, 0.0f, 0.0f);
        } else if (parentType == ParentType.LeggingsPivot) {
            poseStack.m_252880_(0.0f, -0.75f, 0.0f);
        } else if (parentType == ParentType.LeftLeggingPivot) {
            poseStack.m_252880_(-0.125f, -0.75f, 0.0f);
        } else if (parentType == ParentType.RightLeggingPivot) {
            poseStack.m_252880_(0.125f, -0.75f, 0.0f);
        } else if (parentType == ParentType.LeftBootPivot) {
            poseStack.m_252880_(-0.125f, -1.5f, 0.0f);
        } else if (parentType == ParentType.RightBootPivot) {
            poseStack.m_252880_(0.125f, -1.5f, 0.0f);
        }
    }

    @Unique
    default public void figura$prepareArmorRender(PoseStack stack) {
        stack.m_85841_(16.0f, 16.0f, 16.0f);
        stack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
    }
}

