/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.vanilla_model;

import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.model.ParentType;

@LuaWhitelist
@LuaTypeDoc(name="VanillaModelPart", value="vanilla_model_part")
public class VanillaModelPart
extends VanillaPart {
    private final ParentType parentType;
    private final Function<EntityModel<?>, ModelPart> provider;
    private float backupPosX;
    private float backupPosY;
    private float backupPosZ;
    private float backupRotX;
    private float backupRotY;
    private float backupRotZ;
    private float backupScaleX;
    private float backupScaleY;
    private float backupScaleZ;
    private boolean originVisible;
    private boolean saved;
    private final FiguraVec3 originRot = FiguraVec3.of();
    private final FiguraVec3 originPos = FiguraVec3.of();
    private final FiguraVec3 originScale = FiguraVec3.of();

    public VanillaModelPart(Avatar owner, String name, ParentType parentType, Function<EntityModel<?>, ModelPart> provider) {
        super(owner, name);
        this.parentType = parentType;
        this.provider = provider;
    }

    private ModelPart getPart(EntityModel<?> model) {
        return this.provider == null ? null : this.provider.apply(model);
    }

    @Override
    public void save(EntityModel<?> model) {
        this.saved = false;
        ModelPart part = this.getPart(model);
        if (part == null) {
            return;
        }
        this.originRot.set(-part.f_104203_, (double)(-part.f_104204_), (double)part.f_104205_);
        this.originRot.scale(57.29577951308232);
        FiguraVec3 pivot = this.parentType.offset.copy();
        pivot.subtract(part.f_104200_, part.f_104201_, part.f_104202_);
        pivot.multiply(1.0, -1.0, -1.0);
        this.originPos.set(pivot);
        this.originScale.set(part.f_233553_, (double)part.f_233554_, (double)part.f_233555_);
        this.originVisible = part.f_104207_;
        this.backupPosX = part.f_104200_;
        this.backupPosY = part.f_104201_;
        this.backupPosZ = part.f_104202_;
        this.backupRotX = part.f_104203_;
        this.backupRotY = part.f_104204_;
        this.backupRotZ = part.f_104205_;
        this.backupScaleX = part.f_233553_;
        this.backupScaleY = part.f_233554_;
        this.backupScaleZ = part.f_233555_;
        this.saved = true;
    }

    @Override
    public void preTransform(EntityModel<?> model) {
        if (!this.saved) {
            return;
        }
        ModelPart part = this.getPart(model);
        if (part == null) {
            return;
        }
        if (this.pos != null) {
            part.f_104200_ += (float)(-this.pos.x);
            part.f_104201_ += (float)(-this.pos.y);
            part.f_104202_ += (float)this.pos.z;
        }
        if (this.rot != null) {
            FiguraVec3 rot = this.rot.toRad();
            part.m_171327_((float)(-rot.x), (float)(-rot.y), (float)rot.z);
        }
        if (this.offsetRot != null) {
            part.m_252899_(this.offsetRot.toRad().mul(-1, -1.0, 1.0).asVec3f());
        }
        if (this.scale != null) {
            part.f_233553_ = (float)this.scale.x;
            part.f_233554_ = (float)this.scale.y;
            part.f_233555_ = (float)this.scale.z;
        }
        if (this.offsetScale != null) {
            part.m_253072_(this.offsetScale.asVec3f());
        }
    }

    @Override
    public void posTransform(EntityModel<?> model) {
        if (this.visible == null) {
            return;
        }
        ModelPart part = this.getPart(model);
        if (part != null) {
            part.f_104207_ = this.visible;
        }
    }

    @Override
    public void restore(EntityModel<?> model) {
        ModelPart part = this.getPart(model);
        if (part == null) {
            return;
        }
        part.f_104207_ = this.originVisible;
        if (!this.saved) {
            return;
        }
        part.f_104200_ = this.backupPosX;
        part.f_104201_ = this.backupPosY;
        part.f_104202_ = this.backupPosZ;
        part.f_104203_ = this.backupRotX;
        part.f_104204_ = this.backupRotY;
        part.f_104205_ = this.backupRotZ;
        part.f_233553_ = this.backupScaleX;
        part.f_233554_ = this.backupScaleY;
        part.f_233555_ = this.backupScaleZ;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vanilla_model_part.get_origin_visible")
    public boolean getOriginVisible() {
        return this.originVisible;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vanilla_model_part.get_origin_rot")
    public FiguraVec3 getOriginRot() {
        return this.originRot.copy();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vanilla_model_part.get_origin_pos")
    public FiguraVec3 getOriginPos() {
        return this.originPos.copy();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vanilla_model_part.get_origin_scale")
    public FiguraVec3 getOriginScale() {
        return this.originScale.copy();
    }

    @Override
    public String toString() {
        return "VanillaModelPart";
    }
}

