/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.json.JsonAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.utils.LuaUtils;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="JsonSerializer", value="json_serializer")
public class FiguraJsonSerializer {
    private final Gson serializer;

    public FiguraJsonSerializer(Gson serializer) {
        this.serializer = serializer;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="json_serializer.serialize", overloads={@LuaMethodOverload(argumentNames={"val"}, argumentTypes={LuaValue.class}, returnType=String.class)})
    public String serialize(LuaValue val) {
        if (JsonAPI.isSerializable(val)) {
            JsonElement elem = LuaUtils.asJsonValue(val);
            return this.serializer.toJson(elem);
        }
        throw new IllegalArgumentException("Type of provided value (%s) is not serializable".formatted(val.typename()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="json_serializer.deserialize", overloads={@LuaMethodOverload(argumentNames={"str"}, argumentTypes={String.class}, returnType=LuaValue.class)})
    public LuaValue deserialize(String s) {
        JsonElement e = JsonParser.parseString((String)s);
        return FiguraJsonSerializer.luaValueFromElement(e);
    }

    public static LuaValue luaValueFromElement(JsonElement element) {
        if (element.isJsonNull()) {
            return LuaValue.NIL;
        }
        if (element.isJsonPrimitive()) {
            return FiguraJsonSerializer.luaValueFromPrimitive(element.getAsJsonPrimitive());
        }
        if (element.isJsonObject()) {
            return FiguraJsonSerializer.luaTableFromObject(element.getAsJsonObject());
        }
        return FiguraJsonSerializer.luaTableFromArray(element.getAsJsonArray());
    }

    private static LuaTable luaTableFromArray(JsonArray array) {
        LuaTable tbl = new LuaTable();
        int i = 1;
        for (JsonElement elem : array) {
            tbl.set(i, FiguraJsonSerializer.luaValueFromElement(elem));
            ++i;
        }
        return tbl;
    }

    private static LuaTable luaTableFromObject(JsonObject obj) {
        LuaTable tbl = new LuaTable();
        for (Map.Entry kv : obj.entrySet()) {
            tbl.set((String)kv.getKey(), FiguraJsonSerializer.luaValueFromElement((JsonElement)kv.getValue()));
        }
        return tbl;
    }

    private static LuaValue luaValueFromPrimitive(JsonPrimitive primitive) {
        if (primitive.isBoolean()) {
            return LuaValue.valueOf((boolean)primitive.getAsBoolean());
        }
        if (primitive.isString()) {
            return LuaValue.valueOf((String)primitive.getAsString());
        }
        return LuaValue.valueOf((double)primitive.getAsDouble());
    }

    public String toString() {
        return "JsonSerializer";
    }

    public static interface JsonValue {
        public JsonElement getElement();
    }
}

